/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.om.AtomicArray;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.ArrayIterator;
import net.sf.saxon.tree.iter.GroundedIterator;
import net.sf.saxon.tree.iter.ReverseArrayIterator;
import net.sf.saxon.tree.iter.UnfailingIterator;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SingletonItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequenceExtent<T extends Item>
implements GroundedValue {
    private T[] value;
    private int start = 0;
    private int end;
    private ItemType itemType = null;

    public SequenceExtent(T[] items) {
        this.value = items;
        this.end = items.length;
    }

    public SequenceExtent(T[] value, int start, int length) {
        this.value = value;
        this.start = start;
        this.end = this.start + length;
    }

    public SequenceExtent(SequenceExtent<T> ext, int start, int length) {
        this.value = ext.value;
        this.start = ext.start + start;
        this.end = this.start + length;
    }

    public SequenceExtent(List<? extends T> list) {
        Item[] array = new Item[list.size()];
        this.value = list.toArray(array);
        this.end = this.value.length;
    }

    public SequenceExtent(SequenceIterator<T> iter) throws XPathException {
        if ((iter.getProperties() & 2) == 0) {
            T it;
            ArrayList<T> list = new ArrayList<T>(20);
            while ((it = iter.next()) != null) {
                list.add(it);
            }
            Item[] array = new Item[list.size()];
            try {
                this.value = list.toArray(array);
            }
            catch (ArrayStoreException e) {
                e.printStackTrace();
            }
            this.end = this.value.length;
        } else {
            T it;
            this.end = ((LastPositionFinder)((Object)iter)).getLength();
            Item[] array = new Item[this.end];
            this.value = array;
            int i = 0;
            while ((it = iter.next()) != null) {
                this.value[i++] = it;
            }
        }
    }

    public static <T extends Item> GroundedValue makeSequenceExtent(SequenceIterator<T> iter) throws XPathException {
        if ((iter.getProperties() & 1) != 0) {
            return ((GroundedIterator)iter).materialize();
        }
        SequenceExtent<T> extent = new SequenceExtent<T>(iter);
        return extent.reduce();
    }

    public static <T extends Item> Sequence makeSequenceExtent(List<T> input) {
        int len = input.size();
        if (len == 0) {
            return EmptySequence.getInstance();
        }
        if (len == 1) {
            return (Sequence)input.get(0);
        }
        if (SequenceExtent.allAtomicLiterals(input)) {
            AtomicValue[] a = new AtomicValue[input.size()];
            input.toArray(a);
            return new AtomicArray(a);
        }
        return new SequenceExtent<T>(input);
    }

    private static boolean allAtomicLiterals(List<? extends Item> input) {
        for (Item item : input) {
            if (item instanceof AtomicValue) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getStringValue() throws XPathException {
        return SequenceTool.getStringValue(this);
    }

    @Override
    public CharSequence getStringValueCS() throws XPathException {
        return SequenceTool.getStringValue(this);
    }

    @Override
    public Item head() throws XPathException {
        return this.itemAt(0);
    }

    @Override
    public int getLength() {
        return this.end - this.start;
    }

    public int getCardinality() {
        switch (this.end - this.start) {
            case 0: {
                return 8192;
            }
            case 1: {
                return 16384;
            }
        }
        return 49152;
    }

    public ItemType getItemType(TypeHierarchy th) {
        ItemType it = this.itemType;
        if (it != null) {
            return it;
        }
        if (this.end == this.start) {
            it = AnyItemType.getInstance();
        } else if (th == null) {
            int i;
            for (i = this.start; i < this.end; ++i) {
                if (!(this.value[i] instanceof NodeInfo)) continue;
                return this.getItemType(((NodeInfo)this.value[i]).getConfiguration().getTypeHierarchy());
            }
            it = Type.getItemType(this.value[this.start], null);
            for (i = this.start + 1; i < this.end; ++i) {
                if (it == AnyItemType.getInstance()) {
                    return it;
                }
                it = Type.getCommonSuperType(it, Type.getItemType(this.value[i], null), th);
            }
        } else {
            it = Type.getItemType(this.value[this.start], th);
            for (int i = this.start + 1; i < this.end; ++i) {
                if (it == AnyItemType.getInstance()) {
                    return it;
                }
                it = Type.getCommonSuperType(it, Type.getItemType(this.value[i], th), th);
            }
        }
        this.itemType = it;
        return this.itemType;
    }

    public T itemAt(int n) {
        if (n < 0 || n >= this.getLength()) {
            return null;
        }
        return this.value[this.start + n];
    }

    public void swap(int a, int b) {
        T temp = this.value[this.start + a];
        this.value[this.start + a] = this.value[this.start + b];
        this.value[this.start + b] = temp;
    }

    public ArrayIterator<T> iterate() {
        return new ArrayIterator(this.value, this.start, this.end);
    }

    public UnfailingIterator<T> reverseIterate() {
        return new ReverseArrayIterator(this.value, this.start, this.end);
    }

    @Override
    public boolean effectiveBooleanValue() throws XPathException {
        int len = this.getLength();
        if (len == 0) {
            return false;
        }
        if (this.value[this.start] instanceof NodeInfo) {
            return true;
        }
        if (len > 1) {
            return ExpressionTool.effectiveBooleanValue(this.iterate());
        }
        return ((AtomicValue)this.value[this.start]).effectiveBooleanValue();
    }

    @Override
    public GroundedValue subsequence(int start, int length) {
        int newEnd;
        if (start < 0) {
            start = 0;
        } else if (start >= this.end) {
            return EmptySequence.getInstance();
        }
        int newStart = this.start + start;
        if (length == Integer.MAX_VALUE) {
            newEnd = this.end;
        } else {
            if (length < 0) {
                return EmptySequence.getInstance();
            }
            newEnd = newStart + length;
            if (newEnd > this.end) {
                newEnd = this.end;
            }
        }
        return new SequenceExtent(this.value, newStart, newEnd - newStart);
    }

    public String toString() {
        FastStringBuffer fsb = new FastStringBuffer(64);
        fsb.append('(');
        for (int i = this.start; i < this.end; ++i) {
            fsb.append(this.value[i].toString());
            if (i == this.end - 1) continue;
            fsb.append(", ");
        }
        fsb.append(')');
        return fsb.toString();
    }

    @Override
    public GroundedValue reduce() {
        int len = this.getLength();
        if (len == 0) {
            return EmptySequence.getInstance();
        }
        if (len == 1) {
            T item = this.itemAt(0);
            if (item instanceof GroundedValue) {
                return (GroundedValue)item;
            }
            return new SingletonItem<T>(item);
        }
        return this;
    }
}

