/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.expr.sort.GenericAtomicComparer;
import net.sf.saxon.functions.CollatingFunction;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.StringValue;

public class Compare
extends CollatingFunction
implements Callable {
    protected int getCollationArgument() {
        return 2;
    }

    public IntegerValue[] getIntegerBounds() {
        return new IntegerValue[]{Int64Value.MINUS_ONE, Int64Value.PLUS_ONE};
    }

    public void checkArguments(ExpressionVisitor visitor) throws XPathException {
        super.checkArguments(visitor);
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        ItemType type0 = this.argument[0].getItemType(th);
        ItemType type1 = this.argument[1].getItemType(th);
        if (type0 instanceof AtomicType && type1 instanceof AtomicType) {
            this.preAllocateComparer((AtomicType)type0, (AtomicType)type1, visitor.getStaticContext(), false);
        }
    }

    public Int64Value evaluateItem(XPathContext context) throws XPathException {
        StringValue arg0 = (StringValue)this.argument[0].evaluateItem(context);
        StringValue arg1 = (StringValue)this.argument[1].evaluateItem(context);
        AtomicComparer comparer = this.getPreAllocatedAtomicComparer();
        if (comparer == null) {
            comparer = this.getAtomicComparer(this.getCollator(context), context);
        }
        return Compare.compare(arg0, arg1, comparer);
    }

    private static Int64Value compare(StringValue s1, StringValue s2, AtomicComparer comparer) throws XPathException {
        if (s1 == null || s2 == null) {
            return null;
        }
        int result = comparer.compareAtomicValues(s1, s2);
        if (result < 0) {
            return Int64Value.MINUS_ONE;
        }
        if (result > 0) {
            return Int64Value.PLUS_ONE;
        }
        return Int64Value.ZERO;
    }

    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        StringValue arg0 = (StringValue)arguments[0].head();
        StringValue arg1 = (StringValue)arguments[1].head();
        StringCollator collator = this.getCollatorFromLastArgument(arguments, 2, context);
        GenericAtomicComparer comparer = new GenericAtomicComparer(collator, context);
        return Compare.compare(arg0, arg1, comparer);
    }
}

