/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.type;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaComponentVisitor;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.ObjectValue;

public class ExternalObjectType
implements ItemType {
    public static ExternalObjectType EXTERNAL_OBJECT_TYPE = new ExternalObjectType(Object.class);
    private Class javaClass;

    public ExternalObjectType(Class javaClass) {
        this.javaClass = javaClass;
    }

    public ExternalObjectType(Class javaClass, Configuration config) {
        this(javaClass);
    }

    public String getName() {
        return this.javaClass.getName();
    }

    public String getTargetNamespace() {
        return "http://saxon.sf.net/java-type";
    }

    public boolean isExternalType() {
        return true;
    }

    public StructuredQName getTypeName() {
        return new StructuredQName("", "http://saxon.sf.net/java-type", this.javaClass.getName());
    }

    public boolean isPlainType() {
        return false;
    }

    public ItemType getPrimitiveItemType() {
        return EXTERNAL_OBJECT_TYPE;
    }

    public int getPrimitiveType() {
        return 632;
    }

    public AtomicType getAtomizedItemType() {
        return BuiltInAtomicType.STRING;
    }

    public boolean isAtomizable() {
        return true;
    }

    public int getRelationship(ExternalObjectType other) {
        Class j2 = other.javaClass;
        if (this.javaClass.equals(j2)) {
            return 0;
        }
        if (this.javaClass.isAssignableFrom(j2)) {
            return 1;
        }
        if (j2.isAssignableFrom(this.javaClass)) {
            return 2;
        }
        if (this.javaClass.isInterface() || j2.isInterface()) {
            return 3;
        }
        return 4;
    }

    public String getDescription() {
        return this.getDisplayName();
    }

    public boolean isAtomicType() {
        return false;
    }

    public Class getJavaClass() {
        return this.javaClass;
    }

    public boolean matches(Item item, XPathContext context) {
        if (item instanceof ObjectValue) {
            Object obj = ((ObjectValue)item).getObject();
            return this.javaClass.isAssignableFrom(obj.getClass());
        }
        return false;
    }

    public boolean matchesItem(Item item, boolean allowURIPromotion, Configuration config) {
        if (item instanceof ObjectValue) {
            Object obj = ((ObjectValue)item).getObject();
            return this.javaClass.isAssignableFrom(obj.getClass());
        }
        return false;
    }

    public ItemType getSuperType(TypeHierarchy th) {
        if (this.javaClass == Object.class) {
            return AnyItemType.getInstance();
        }
        Class javaSuper = this.javaClass.getSuperclass();
        if (javaSuper == null) {
            return EXTERNAL_OBJECT_TYPE;
        }
        return new ExternalObjectType(javaSuper);
    }

    public String toString() {
        return this.getDisplayName();
    }

    public String getDisplayName() {
        return "java-type:" + this.javaClass.getName();
    }

    public double getDefaultPriority() {
        return 0.0;
    }

    public void visitNamedSchemaComponents(SchemaComponentVisitor visitor) throws XPathException {
    }

    public int hashCode() {
        return this.javaClass.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof ExternalObjectType && this.javaClass == ((ExternalObjectType)obj).javaClass;
    }
}

