/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import java.util.HashMap;
import java.util.Iterator;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.MonoIterator;
import net.sf.saxon.expr.PendingUpdateList;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.Instruction;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PromotionOffer;
import net.sf.saxon.lib.TraceListener;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trace.InstructionInfo;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TraceExpression
extends Instruction
implements InstructionInfo {
    private StructuredQName objectName;
    private int constructType;
    private NamespaceResolver namespaceResolver = null;
    private HashMap<String, Object> properties = new HashMap(10);
    Expression child;

    public TraceExpression(Expression child) {
        this.child = child;
        this.adoptChildExpression(child);
        this.setProperty("expression", child);
    }

    public void setConstructType(int type) {
        this.constructType = type;
    }

    @Override
    public int getConstructType() {
        return this.constructType;
    }

    public void setNamespaceResolver(NamespaceResolver resolver) {
        this.namespaceResolver = resolver;
    }

    public NamespaceResolver getNamespaceResolver() {
        return this.namespaceResolver;
    }

    public void setObjectName(StructuredQName qName) {
        this.objectName = qName;
    }

    @Override
    public StructuredQName getObjectName() {
        return this.objectName;
    }

    public void setProperty(String name, Object value) {
        this.properties.put(name, value);
    }

    @Override
    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    @Override
    public Iterator<String> getProperties() {
        return this.properties.keySet().iterator();
    }

    public InstructionInfo getInstructionInfo() {
        return this;
    }

    @Override
    public String getSystemId(long locationId) {
        return this.getSystemId();
    }

    @Override
    public int getLineNumber(long locationId) {
        return this.getLineNumber();
    }

    @Override
    public int getColumnNumber(long locationId) {
        return this.getColumnNumber();
    }

    @Override
    public Expression copy() {
        TraceExpression t = new TraceExpression(this.child.copy());
        t.objectName = this.objectName;
        t.namespaceResolver = this.namespaceResolver;
        t.constructType = this.constructType;
        return t;
    }

    @Override
    public boolean isUpdatingExpression() {
        return this.child.isUpdatingExpression();
    }

    @Override
    public boolean isVacuousExpression() {
        return this.child.isVacuousExpression();
    }

    @Override
    public void checkForUpdatingSubexpressions() throws XPathException {
        this.child.checkForUpdatingSubexpressions();
    }

    @Override
    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        this.child = visitor.simplify(this.child);
        if (this.child instanceof TraceExpression) {
            return this.child;
        }
        return this;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        this.child = visitor.typeCheck(this.child, contextItemType);
        this.adoptChildExpression(this.child);
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        this.child = visitor.optimize(this.child, contextItemType);
        this.adoptChildExpression(this.child);
        return this;
    }

    @Override
    public int getImplementationMethod() {
        return this.child.getImplementationMethod();
    }

    @Override
    public Expression promote(PromotionOffer offer, Expression parent) throws XPathException {
        Expression newChild = this.child.promote(offer, parent);
        if (newChild != this.child) {
            this.child = newChild;
            this.adoptChildExpression(this.child);
            return this;
        }
        return this;
    }

    @Override
    public TailCall processLeavingTail(XPathContext context) throws XPathException {
        Controller controller = context.getController();
        assert (controller != null);
        TraceListener listener = controller.getTraceListener();
        if (controller.isTracing()) {
            assert (listener != null);
            listener.enter(this.getInstructionInfo(), context);
        }
        this.child.process(context);
        if (controller.isTracing()) {
            assert (listener != null);
            listener.leave(this.getInstructionInfo());
        }
        return null;
    }

    @Override
    public ItemType getItemType(TypeHierarchy th) {
        return this.child.getItemType(th);
    }

    @Override
    public int getCardinality() {
        return this.child.getCardinality();
    }

    @Override
    public int getDependencies() {
        return this.child.getDependencies();
    }

    @Override
    public final boolean createsNewNodes() {
        return (this.child.getSpecialProperties() & 0x400000) == 0;
    }

    @Override
    public int computeDependencies() {
        return this.child.computeDependencies();
    }

    @Override
    public Item evaluateItem(XPathContext context) throws XPathException {
        Controller controller = context.getController();
        assert (controller != null);
        if (controller.isTracing()) {
            controller.getTraceListener().enter(this.getInstructionInfo(), context);
        }
        Item result = this.child.evaluateItem(context);
        if (controller.isTracing()) {
            controller.getTraceListener().leave(this.getInstructionInfo());
        }
        return result;
    }

    public SequenceIterator<Item> iterate(XPathContext context) throws XPathException {
        Controller controller = context.getController();
        assert (controller != null);
        if (controller.isTracing()) {
            controller.getTraceListener().enter(this.getInstructionInfo(), context);
        }
        SequenceIterator<Item> result = this.child.iterate(context);
        if (controller.isTracing()) {
            controller.getTraceListener().leave(this.getInstructionInfo());
        }
        return result;
    }

    @Override
    public Iterator<Expression> iterateSubExpressions() {
        return new MonoIterator<Expression>(this.child);
    }

    @Override
    public boolean replaceSubExpression(Expression original, Expression replacement) {
        boolean found = false;
        if (this.child == original) {
            this.child = replacement;
            found = true;
        }
        return found;
    }

    public Expression getChildExpression() {
        return this.child;
    }

    @Override
    public int getInstructionNameCode() {
        if (this.child instanceof Instruction) {
            return ((Instruction)this.child).getInstructionNameCode();
        }
        return -1;
    }

    @Override
    public void explain(ExpressionPresenter out) {
        this.child.explain(out);
    }

    @Override
    public void evaluatePendingUpdates(XPathContext context, PendingUpdateList pul) throws XPathException {
        Controller controller = context.getController();
        assert (controller != null);
        if (controller.isTracing()) {
            controller.getTraceListener().enter(this.getInstructionInfo(), context);
        }
        this.child.evaluatePendingUpdates(context, pul);
        if (controller.isTracing()) {
            controller.getTraceListener().leave(this.getInstructionInfo());
        }
    }
}

