/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trans;

import java.io.Serializable;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.instruct.Procedure;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.PatternFinder;
import net.sf.saxon.type.BuiltInAtomicType;

public class KeyDefinition
extends Procedure
implements Serializable {
    private PatternFinder match;
    private Expression use;
    private BuiltInAtomicType useType;
    private StringCollator collation;
    private String collationName;
    private boolean backwardsCompatible = false;
    private boolean strictComparison = false;
    private boolean convertUntypedToOther = false;
    private boolean rangeKey = false;

    public KeyDefinition(PatternFinder match, Expression use, String collationName, StringCollator collation) {
        this.setHostLanguage(50);
        this.match = match;
        this.use = use;
        if (use instanceof Expression) {
            this.setBody(use);
        }
        this.collation = collation;
        this.collationName = collationName;
    }

    public void setRangeKey(boolean rangeKey) {
        this.rangeKey = rangeKey;
    }

    public boolean isRangeKey() {
        return this.rangeKey;
    }

    public void setIndexedItemType(BuiltInAtomicType itemType) {
        this.useType = itemType;
    }

    public BuiltInAtomicType getIndexedItemType() {
        if (this.useType == null) {
            return BuiltInAtomicType.ANY_ATOMIC;
        }
        return this.useType;
    }

    public void setBackwardsCompatible(boolean bc) {
        this.backwardsCompatible = bc;
    }

    public boolean isBackwardsCompatible() {
        return this.backwardsCompatible;
    }

    public void setStrictComparison(boolean strict) {
        this.strictComparison = strict;
    }

    public boolean isStrictComparison() {
        return this.strictComparison;
    }

    public void setConvertUntypedToOther(boolean convertToOther) {
        this.convertUntypedToOther = convertToOther;
    }

    public boolean isConvertUntypedToOther() {
        return this.convertUntypedToOther;
    }

    public void setStackFrameMap(SlotManager map) {
        if (map != null && map.getNumberOfVariables() > 0) {
            super.setStackFrameMap(map);
        }
    }

    public void setLocation(String systemId, int lineNumber) {
        this.setSystemId(systemId);
        this.setLineNumber(lineNumber);
    }

    public PatternFinder getMatch() {
        return this.match;
    }

    public void setBody(Expression body) {
        super.setBody(body);
        this.use = body;
    }

    public Expression getUse() {
        return this.use;
    }

    public String getCollationName() {
        return this.collationName;
    }

    public StringCollator getCollation() {
        return this.collation;
    }

    public int getConstructType() {
        return 165;
    }

    public StructuredQName getObjectName() {
        return null;
    }
}

