/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.s9api;

import java.io.File;
import java.io.OutputStream;
import java.io.Writer;
import javax.xml.transform.Source;
import net.sf.saxon.Configuration;
import net.sf.saxon.Version;
import net.sf.saxon.event.NamespaceReducer;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.TreeReceiver;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.DocumentBuilder;
import net.sf.saxon.s9api.ExtensionFunction;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.SchemaManager;
import net.sf.saxon.s9api.SequenceType;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XPathCompiler;
import net.sf.saxon.s9api.XQueryCompiler;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.s9api.XsltCompiler;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceExtent;

public class Processor {
    private Configuration config;
    private SchemaManager schemaManager;

    public Processor(boolean licensedEdition) {
        if (licensedEdition) {
            this.config = Configuration.newConfiguration();
            if (this.config.getEditionCode().equals("EE")) {
                this.schemaManager = new SchemaManager(this.config);
            }
        } else {
            this.config = new Configuration();
        }
        this.config.setProcessor(this);
    }

    public Processor(Configuration config) {
        this.config = config;
        if (config.getEditionCode().equals("EE")) {
            this.schemaManager = new SchemaManager(config);
        }
    }

    public Processor(Source source) throws SaxonApiException {
        try {
            this.config = Configuration.readConfiguration(source);
            this.schemaManager = new SchemaManager(this.config);
        }
        catch (XPathException e) {
            throw new SaxonApiException(e);
        }
        this.config.setProcessor(this);
    }

    public DocumentBuilder newDocumentBuilder() {
        return new DocumentBuilder(this.config);
    }

    public XPathCompiler newXPathCompiler() {
        return new XPathCompiler(this);
    }

    public XsltCompiler newXsltCompiler() {
        return new XsltCompiler(this);
    }

    public XQueryCompiler newXQueryCompiler() {
        return new XQueryCompiler(this);
    }

    public Serializer newSerializer() {
        Serializer s = new Serializer();
        s.setProcessor(this);
        return s;
    }

    public Serializer newSerializer(OutputStream stream) {
        Serializer s = new Serializer();
        s.setProcessor(this);
        s.setOutputStream(stream);
        return s;
    }

    public Serializer newSerializer(Writer writer) {
        Serializer s = new Serializer();
        s.setProcessor(this);
        s.setOutputWriter(writer);
        return s;
    }

    public Serializer newSerializer(File file) {
        Serializer s = new Serializer();
        s.setProcessor(this);
        s.setOutputFile(file);
        return s;
    }

    public void registerExtensionFunction(ExtensionFunction function) {
        ExtensionFunctionDefinitionWrapper wrapper = new ExtensionFunctionDefinitionWrapper(function);
        this.registerExtensionFunction(wrapper);
    }

    public void registerExtensionFunction(ExtensionFunctionDefinition function) {
        try {
            this.config.registerExtensionFunction(function);
        }
        catch (Exception err) {
            throw new IllegalArgumentException(err);
        }
    }

    public SchemaManager getSchemaManager() {
        return this.schemaManager;
    }

    public boolean isSchemaAware() {
        return this.config.isLicensedFeature(1);
    }

    public String getSaxonProductVersion() {
        return Version.getProductVersion();
    }

    public void setXmlVersion(String version) {
        if (version.equals("1.0")) {
            this.config.setXMLVersion(10);
        } else if (version.equals("1.1")) {
            this.config.setXMLVersion(11);
        } else {
            throw new IllegalArgumentException("XmlVersion");
        }
    }

    public String getXmlVersion() {
        if (this.config.getXMLVersion() == 10) {
            return "1.0";
        }
        return "1.1";
    }

    public void setConfigurationProperty(String name, Object value) {
        this.config.setConfigurationProperty(name, value);
    }

    public Object getConfigurationProperty(String name) {
        return this.config.getConfigurationProperty(name);
    }

    public Configuration getUnderlyingConfiguration() {
        return this.config;
    }

    public void writeXdmValue(XdmValue value, Destination destination) throws SaxonApiException {
        try {
            Receiver out = destination.getReceiver(this.config);
            out = new NamespaceReducer(out);
            TreeReceiver tree = new TreeReceiver(out);
            tree.open();
            tree.startDocument(0);
            for (XdmItem item : value) {
                tree.append((Item)item.getUnderlyingValue(), 0, 2);
            }
            tree.endDocument();
            tree.close();
            destination.close();
        }
        catch (XPathException err) {
            throw new SaxonApiException(err);
        }
    }

    private static class ExtensionFunctionDefinitionWrapper
    extends ExtensionFunctionDefinition {
        private ExtensionFunction function;

        public ExtensionFunctionDefinitionWrapper(ExtensionFunction function) {
            this.function = function;
        }

        public StructuredQName getFunctionQName() {
            return this.function.getName().getStructuredQName();
        }

        public int getMinimumNumberOfArguments() {
            return this.function.getArgumentTypes().length;
        }

        public int getMaximumNumberOfArguments() {
            return this.function.getArgumentTypes().length;
        }

        public net.sf.saxon.value.SequenceType[] getArgumentTypes() {
            SequenceType[] declaredArgs = this.function.getArgumentTypes();
            net.sf.saxon.value.SequenceType[] types = new net.sf.saxon.value.SequenceType[declaredArgs.length];
            for (int i = 0; i < declaredArgs.length; ++i) {
                types[i] = net.sf.saxon.value.SequenceType.makeSequenceType(declaredArgs[i].getItemType().getUnderlyingItemType(), declaredArgs[i].getOccurrenceIndicator().getCardinality());
            }
            return types;
        }

        public net.sf.saxon.value.SequenceType getResultType(net.sf.saxon.value.SequenceType[] suppliedArgumentTypes) {
            SequenceType declaredResult = this.function.getResultType();
            return net.sf.saxon.value.SequenceType.makeSequenceType(declaredResult.getItemType().getUnderlyingItemType(), declaredResult.getOccurrenceIndicator().getCardinality());
        }

        public boolean trustResultType() {
            return false;
        }

        public boolean dependsOnFocus() {
            return false;
        }

        public boolean hasSideEffects() {
            return false;
        }

        public ExtensionFunctionCall makeCallExpression() {
            return new ExtensionFunctionCall(){

                public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
                    XdmValue[] args = new XdmValue[arguments.length];
                    for (int i = 0; i < args.length; ++i) {
                        GroundedValue val = SequenceExtent.makeSequenceExtent(arguments[i].iterate());
                        args[i] = XdmValue.wrap(val);
                    }
                    try {
                        XdmValue result = ExtensionFunctionDefinitionWrapper.this.function.call(args);
                        return result.getUnderlyingValue();
                    }
                    catch (SaxonApiException e) {
                        throw new XPathException(e);
                    }
                }
            };
        }
    }
}

