/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.Procedure;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;

public class AttributeSet
extends Procedure {
    StructuredQName attributeSetName;
    private AttributeSet[] useAttributeSets;

    public AttributeSet() {
        this.setHostLanguage(50);
    }

    public void setName(StructuredQName attributeSetName) {
        this.attributeSetName = attributeSetName;
    }

    public void setUseAttributeSets(AttributeSet[] useAttributeSets) {
        this.useAttributeSets = useAttributeSets;
    }

    public void setStackFrameMap(SlotManager stackFrameMap) {
        if (stackFrameMap != null && stackFrameMap.getNumberOfVariables() > 0) {
            super.setStackFrameMap(stackFrameMap);
        }
    }

    public int getFocusDependencies() {
        int d = 0;
        if (this.body != null) {
            d |= this.body.getDependencies() & 0x1E;
        }
        if (this.useAttributeSets != null) {
            for (AttributeSet useAttributeSet : this.useAttributeSets) {
                d |= useAttributeSet.getFocusDependencies();
            }
        }
        return d;
    }

    public void expand(XPathContext context) throws XPathException {
        if (this.useAttributeSets != null) {
            AttributeSet.expand(this.useAttributeSets, context);
        }
        if (this.getStackFrameMap() != null) {
            XPathContextMajor c2 = context.newContext();
            c2.setOrigin(this);
            c2.openStackFrame(this.getStackFrameMap());
            this.getBody().process(c2);
        } else {
            this.getBody().process(context);
        }
    }

    public int getConstructType() {
        return 135;
    }

    public StructuredQName getObjectName() {
        return this.attributeSetName;
    }

    public static void expand(AttributeSet[] asets, XPathContext context) throws XPathException {
        for (AttributeSet aset : asets) {
            aset.expand(context);
        }
    }
}

