/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.xqj;

import java.io.PrintWriter;
import java.sql.Connection;
import java.util.Enumeration;
import java.util.Properties;
import javax.xml.xquery.XQConnection;
import javax.xml.xquery.XQDataSource;
import javax.xml.xquery.XQException;
import net.sf.saxon.Configuration;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.lib.Validation;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.xqj.SaxonXQConnection;

public class SaxonXQDataSource
implements XQDataSource {
    private Configuration config;
    private PrintWriter logger;
    private static String[] supportedPropertyNames = new String[]{"allowExternalFunctions", "dtdValidation", "expandAttributeDefaults", "expandXInclude", "retainLineNumbers", "schemaValidationMode", "stripWhitespace", "useXsiSchemaLocation", "xmlVersion", "xsdVersion"};

    public SaxonXQDataSource() {
        this.config = Configuration.newConfiguration();
        this.config.setProcessor((Object)this);
    }

    public SaxonXQDataSource(Configuration config) {
        this.config = config;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public XQConnection getConnection() throws XQException {
        return new SaxonXQConnection(this);
    }

    public XQConnection getConnection(Connection con) throws XQException {
        throw new XQException("Saxon cannot connect to a SQL data source");
    }

    public XQConnection getConnection(String username, String password) throws XQException {
        return this.getConnection();
    }

    public int getLoginTimeout() {
        return 0;
    }

    public PrintWriter getLogWriter() {
        return this.logger;
    }

    public String getProperty(String name) throws XQException {
        SaxonXQDataSource.checkNotNull(name, "name");
        if ("allowExternalFunctions".equals(name)) {
            return this.getAllowExternalFunctions();
        }
        if ("dtdValidation".equals(name)) {
            return this.getDtdValidation();
        }
        if ("expandAttributeDefaults".equals(name)) {
            return this.getExpandAttributeDefaults();
        }
        if ("expandXInclude".equals(name)) {
            return this.getExpandXInclude();
        }
        if ("retainLineNumbers".equals(name)) {
            return this.getRetainLineNumbers();
        }
        if ("schemaValidationMode".equals(name)) {
            return this.getSchemaValidationMode();
        }
        if ("stripWhitespace".equals(name)) {
            return this.getStripWhitespace();
        }
        if ("useXsiSchemaLocation".equals(name)) {
            return this.getUseXsiSchemaLocation();
        }
        if ("xmlVersion".equals(name)) {
            return this.getXmlVersion();
        }
        if ("xsdVersion".equals(name)) {
            return this.getXsdVersion();
        }
        try {
            return this.config.getConfigurationProperty(name).toString();
        }
        catch (IllegalArgumentException e) {
            throw new XQException("Property " + name + " is not recognized");
        }
        catch (NullPointerException err) {
            throw new XQException("Null property name or value");
        }
    }

    public String[] getSupportedPropertyNames() {
        return supportedPropertyNames;
    }

    public void setLoginTimeout(int seconds) throws XQException {
    }

    public void setLogWriter(PrintWriter out) throws XQException {
        this.logger = out;
    }

    public void setProperties(Properties props) throws XQException {
        SaxonXQDataSource.checkNotNull(props, "props");
        Enumeration<Object> iter = props.keys();
        while (iter.hasMoreElements()) {
            String name = (String)iter.nextElement();
            String value = props.getProperty(name);
            this.setProperty(name, value);
        }
    }

    public void setProperty(String name, String value) throws XQException {
        SaxonXQDataSource.checkNotNull(name, "name");
        SaxonXQDataSource.checkNotNull(value, "value");
        if ("allowExternalFunctions".equals(name)) {
            this.setAllowExternalFunctions(value);
        } else if ("dtdValidation".equals(name)) {
            this.setDtdValidation(value);
        } else if ("expandAttributeDefaults".equals(name)) {
            this.setExpandAttributeDefaults(value);
        } else if ("expandXInclude".equals(name)) {
            this.setExpandXInclude(value);
        } else if ("retainLineNumbers".equals(name)) {
            this.setRetainLineNumbers(value);
        } else if ("schemaValidationMode".equals(name)) {
            this.setSchemaValidationMode(value);
        } else if ("stripWhitespace".equals(name)) {
            this.setStripWhitespace(value);
        } else if ("useXsiSchemaLocation".equals(name)) {
            this.setUseXsiSchemaLocation(value);
        } else if ("xmlVersion".equals(name)) {
            this.setXmlVersion(value);
        } else if ("xsdVersion".equals(name)) {
            this.setXsdVersion(value);
        } else {
            try {
                this.config.setConfigurationProperty(name, (Object)value);
            }
            catch (IllegalArgumentException err) {
                throw new XQException("Unrecognized property or invalid value for " + name + ": " + err.getMessage());
            }
            catch (NullPointerException err) {
                throw new XQException("Null property name or value");
            }
        }
    }

    static void checkNotNull(Object arg, String name) throws XQException {
        if (arg == null) {
            throw new XQException("Argument " + name + " is null");
        }
    }

    public void setAllowExternalFunctions(String value) {
        if ("true".equals(value)) {
            this.config.setBooleanProperty("http://saxon.sf.net/feature/allow-external-functions", true);
        } else if ("false".equals(value)) {
            this.config.setBooleanProperty("http://saxon.sf.net/feature/allow-external-functions", false);
        } else {
            throw new IllegalArgumentException("allowExternalFunctions");
        }
    }

    public String getAllowExternalFunctions() {
        return this.config.getBooleanProperty("http://saxon.sf.net/feature/allow-external-functions") ? "true" : "false";
    }

    public void setDtdValidation(String value) {
        if ("true".equals(value)) {
            this.config.setValidation(true);
        } else if ("false".equals(value)) {
            this.config.setValidation(false);
        } else {
            throw new IllegalArgumentException("dtdValidation");
        }
    }

    public String getDtdValidation() {
        return this.config.isValidation() ? "true" : "false";
    }

    public void setExpandAttributeDefaults(String value) {
        if ("true".equals(value)) {
            this.config.setExpandAttributeDefaults(true);
        } else if ("false".equals(value)) {
            this.config.setExpandAttributeDefaults(false);
        } else {
            throw new IllegalArgumentException("expandAttributeDefaults");
        }
    }

    public String getExpandAttributeDefaults() {
        return this.config.isExpandAttributeDefaults() ? "true" : "false";
    }

    public void setExpandXInclude(String value) {
        if ("true".equals(value)) {
            this.config.setXIncludeAware(true);
        } else if ("false".equals(value)) {
            this.config.setXIncludeAware(false);
        } else {
            throw new IllegalArgumentException("expandXInclude");
        }
    }

    public String getExpandXInclude() {
        return this.config.isXIncludeAware() ? "true" : "false";
    }

    public void setRetainLineNumbers(String value) {
        if ("true".equals(value)) {
            this.config.setLineNumbering(true);
        } else if ("false".equals(value)) {
            this.config.setLineNumbering(false);
        } else {
            throw new IllegalArgumentException("retainLineNumbers");
        }
    }

    public String getRetainLineNumbers() {
        return this.config.isLineNumbering() ? "true" : "false";
    }

    public void setSchemaValidationMode(String value) {
        if ("strict".equals(value)) {
            this.config.setSchemaValidationMode(1);
        } else if ("lax".equals(value)) {
            this.config.setSchemaValidationMode(2);
        } else if ("skip".equals(value)) {
            this.config.setSchemaValidationMode(4);
        } else {
            throw new IllegalArgumentException("schemaValidationMode");
        }
    }

    public String getSchemaValidationMode() {
        return Validation.toString((int)this.config.getSchemaValidationMode());
    }

    public void setStripWhitespace(String value) {
        if ("all".equals(value)) {
            this.config.setStripsWhiteSpace(2);
        } else if ("ignorable".equals(value)) {
            this.config.setStripsWhiteSpace(1);
        } else if ("none".equals(value)) {
            this.config.setStripsWhiteSpace(0);
        } else {
            throw new IllegalArgumentException("stripWhitespace");
        }
    }

    public String getStripWhitespace() {
        switch (this.config.getStripsWhiteSpace()) {
            case 2: {
                return "all";
            }
            case 1: {
                return "ignorable";
            }
        }
        return "none";
    }

    public void setUseXsiSchemaLocation(String value) {
        if ("true".equals(value)) {
            this.config.setConfigurationProperty("http://saxon.sf.net/feature/useXsiSchemaLocation", (Object)BooleanValue.TRUE);
        } else if ("false".equals(value)) {
            this.config.setConfigurationProperty("http://saxon.sf.net/feature/useXsiSchemaLocation", (Object)BooleanValue.FALSE);
        } else {
            throw new IllegalArgumentException("useXsiSchemaLocation");
        }
    }

    public String getUseXsiSchemaLocation() {
        Boolean b = (Boolean)this.config.getConfigurationProperty("http://saxon.sf.net/feature/useXsiSchemaLocation");
        return b != false ? "true" : "false";
    }

    public void setXmlVersion(String value) {
        if ("1.0".equals(value)) {
            this.config.setXMLVersion(10);
        } else if ("1.1".equals(value)) {
            this.config.setXMLVersion(11);
        } else {
            throw new IllegalArgumentException("xmlVersion");
        }
    }

    public String getXmlVersion() {
        return this.config.getXMLVersion() == 10 ? "1.0" : "1.1";
    }

    public void setXsdVersion(String value) {
        if ("1.0".equals(value)) {
            this.config.setConfigurationProperty("http://saxon.sf.net/feature/xsd-version", (Object)"1.0");
        } else if ("1.1".equals(value)) {
            this.config.setConfigurationProperty("http://saxon.sf.net/feature/xsd-version", (Object)"1.1");
        } else {
            throw new IllegalArgumentException("xsdVersion");
        }
    }

    public String getXsdVersion() {
        return (String)this.config.getConfigurationProperty("http://saxon.sf.net/feature/xsd-version");
    }

    public void registerExtensionFunction(ExtensionFunctionDefinition function) {
        try {
            this.config.registerExtensionFunction(function);
        }
        catch (Exception err) {
            throw new IllegalArgumentException(err);
        }
    }
}

