/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Stack;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.ArrayIterator;
import net.sf.saxon.tree.iter.GroundedIterator;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.SingletonItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Chain
implements GroundedValue {
    private List<GroundedValue> children = new ArrayList<GroundedValue>();
    private Item[] extent = null;

    public Chain(List<GroundedValue> children) {
        this.children = children;
        int size = 0;
        boolean copy = false;
        for (GroundedValue gv : children) {
            if (gv instanceof Chain) {
                if (((Chain)gv).children.size() < 30) {
                    size += ((Chain)gv).children.size();
                    copy = true;
                    continue;
                }
                ++size;
                continue;
            }
            ++size;
        }
        if (copy) {
            this.children = new ArrayList<GroundedValue>(size);
            for (GroundedValue gv : children) {
                if (gv instanceof Chain) {
                    if (((Chain)gv).children.size() < 30) {
                        this.children.addAll(((Chain)gv).children);
                        continue;
                    }
                    this.children.add(gv);
                    continue;
                }
                this.children.add(gv);
            }
        } else {
            this.children = children;
        }
    }

    @Override
    public Item head() throws XPathException {
        for (Sequence sequence : this.children) {
            Item head = sequence.head();
            if (head == null) continue;
            return head;
        }
        return null;
    }

    public SequenceIterator<Item> iterate() {
        if (this.extent != null) {
            return new ArrayIterator(this.extent);
        }
        return new ChainIterator();
    }

    public void append(GroundedValue sequence) {
        if (this.extent != null) {
            throw new IllegalStateException();
        }
        this.children.add(sequence);
    }

    public void append(Item item) {
        if (this.extent != null) {
            throw new IllegalStateException();
        }
        if (item instanceof GroundedValue) {
            this.children.add((GroundedValue)((Object)item));
        } else {
            this.children.add(new SingletonItem<Item>(item));
        }
    }

    private void consolidate() {
        if (this.extent == null) {
            try {
                Item item;
                ArrayList<Item> content = new ArrayList<Item>();
                SequenceIterator<Item> iter = this.iterate();
                while ((item = iter.next()) != null) {
                    content.add(item);
                }
                Item[] array = new Item[content.size()];
                this.extent = content.toArray(array);
            }
            catch (XPathException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    @Override
    public Item itemAt(int n) {
        this.consolidate();
        if (n >= 0 && n < this.extent.length) {
            return this.extent[n];
        }
        return null;
    }

    @Override
    public GroundedValue subsequence(int start, int length) {
        int newEnd;
        this.consolidate();
        if (start < 0) {
            start = 0;
        } else if (start >= this.extent.length) {
            return EmptySequence.getInstance();
        }
        int newStart = start;
        if (length == Integer.MAX_VALUE) {
            newEnd = this.extent.length;
        } else {
            if (length < 0) {
                return EmptySequence.getInstance();
            }
            newEnd = newStart + length;
            if (newEnd > this.extent.length) {
                newEnd = this.extent.length;
            }
        }
        return new SequenceExtent(this.extent, newStart, newEnd - newStart);
    }

    @Override
    public int getLength() {
        if (this.extent != null) {
            return this.extent.length;
        }
        int n = 0;
        for (GroundedValue v : this.children) {
            n += v.getLength();
        }
        return n;
    }

    @Override
    public boolean effectiveBooleanValue() throws XPathException {
        return ExpressionTool.effectiveBooleanValue(this.iterate());
    }

    @Override
    public String getStringValue() throws XPathException {
        return SequenceTool.getStringValue(this);
    }

    @Override
    public CharSequence getStringValueCS() throws XPathException {
        return SequenceTool.getStringValue(this);
    }

    @Override
    public GroundedValue reduce() {
        this.consolidate();
        return new SequenceExtent(this.extent);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ChainIterator
    implements SequenceIterator<Item>,
    GroundedIterator<Item> {
        private Queue<SequenceIterator> queue = new LinkedList<SequenceIterator>();
        private Stack<ChainPosition> stack = new Stack();
        private Item current;
        private int position = 0;

        public ChainIterator() {
            this.stack.push(new ChainPosition(Chain.this, 0));
        }

        @Override
        public Item next() throws XPathException {
            while (!this.queue.isEmpty()) {
                SequenceIterator ui = this.queue.peek();
                while (ui != null) {
                    this.current = ui.next();
                    if (this.current != null) {
                        ++this.position;
                        return this.current;
                    }
                    this.queue.remove();
                    ui = this.queue.peek();
                }
            }
            while (!this.stack.isEmpty()) {
                ChainPosition cp = this.stack.peek();
                if (cp == null) continue;
                GroundedValue gv = (GroundedValue)cp.chain.children.get(cp.offset);
                if (++cp.offset >= cp.chain.children.size()) {
                    this.stack.pop();
                }
                if (gv instanceof Chain) {
                    this.stack.push(new ChainPosition((Chain)gv, 0));
                    continue;
                }
                try {
                    this.queue.offer(gv.iterate());
                }
                catch (XPathException e) {
                    throw new AssertionError((Object)e);
                }
                return this.next();
            }
            this.current = null;
            this.position = -1;
            return null;
        }

        @Override
        public Item current() {
            return this.current;
        }

        @Override
        public int position() {
            return this.position;
        }

        @Override
        public void close() {
        }

        public ChainIterator getAnother() {
            return new ChainIterator();
        }

        @Override
        public int getProperties() {
            return 1;
        }

        @Override
        public GroundedValue materialize() throws XPathException {
            return Chain.this;
        }

        private class ChainPosition {
            Chain chain;
            int offset;

            public ChainPosition(Chain chain, int offset) {
                this.chain = chain;
                this.offset = offset;
            }
        }
    }
}

