/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.s9api;

import java.util.ArrayList;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.s9api.SaxonApiUncheckedException;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmEmptySequence;
import net.sf.saxon.s9api.XdmExternalObject;
import net.sf.saxon.s9api.XdmFunctionItem;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmSequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.SingletonItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XdmValue
implements Iterable<XdmItem> {
    private Sequence value;

    protected XdmValue() {
    }

    public XdmValue(Iterable<XdmItem> items) {
        ArrayList<Item> values = new ArrayList<Item>();
        for (XdmItem item : items) {
            values.add((Item)item.getUnderlyingValue());
        }
        this.value = new SequenceExtent(values);
    }

    protected XdmValue(Sequence value) {
        this.setValue(value);
    }

    protected void setValue(Sequence value) {
        this.value = value;
    }

    public static XdmValue wrap(Sequence value) {
        if (value == null) {
            return XdmEmptySequence.getInstance();
        }
        if (value instanceof NodeInfo) {
            return new XdmNode((NodeInfo)value);
        }
        if (value instanceof AtomicValue) {
            return new XdmAtomicValue((AtomicValue)value);
        }
        if (value instanceof ObjectValue) {
            return new XdmExternalObject(((ObjectValue)value).getObject());
        }
        if (value instanceof SingletonItem) {
            Object item = ((SingletonItem)value).asItem();
            if (item instanceof NodeInfo) {
                return new XdmNode((NodeInfo)item);
            }
            if (item instanceof AtomicValue) {
                return new XdmAtomicValue((AtomicValue)item);
            }
            if (item instanceof FunctionItem) {
                return new XdmFunctionItem((FunctionItem)item);
            }
            if (item instanceof ObjectValue) {
                return new XdmExternalObject(((ObjectValue)item).getObject());
            }
            throw new AssertionError((Object)"Unknown kind of item");
        }
        try {
            value = SequenceTool.toGroundedValue(value);
        }
        catch (XPathException e) {
            throw new SaxonApiUncheckedException(e);
        }
        if (value == null) {
            return XdmEmptySequence.getInstance();
        }
        if (value instanceof NodeInfo) {
            return new XdmNode((NodeInfo)value);
        }
        if (value instanceof AtomicValue) {
            return new XdmAtomicValue((AtomicValue)value);
        }
        if (value instanceof EmptySequence) {
            return XdmEmptySequence.getInstance();
        }
        if (value instanceof FunctionItem) {
            return new XdmFunctionItem((FunctionItem)value);
        }
        if (value instanceof SingletonItem) {
            return XdmValue.wrap(((SingletonItem)value).asItem());
        }
        return new XdmValue(value);
    }

    public XdmValue append(XdmValue otherValue) {
        ArrayList<Item> values = new ArrayList<Item>();
        for (XdmItem item : this) {
            values.add((Item)item.getUnderlyingValue());
        }
        for (XdmItem item : otherValue) {
            values.add((Item)item.getUnderlyingValue());
        }
        return new XdmValue(new SequenceExtent(values));
    }

    public int size() {
        try {
            return SequenceTool.getLength(this.value);
        }
        catch (XPathException err) {
            throw new SaxonApiUncheckedException(err);
        }
    }

    public XdmItem itemAt(int n) throws IndexOutOfBoundsException, SaxonApiUncheckedException {
        if (n < 0 || n >= this.size()) {
            throw new IndexOutOfBoundsException("" + n);
        }
        try {
            Item item = SequenceTool.itemAt(this.value, n);
            return (XdmItem)XdmItem.wrap(item);
        }
        catch (XPathException e) {
            throw new SaxonApiUncheckedException(e);
        }
    }

    public XdmSequenceIterator iterator() throws SaxonApiUncheckedException {
        try {
            Sequence v = this.getUnderlyingValue();
            return new XdmSequenceIterator(v.iterate());
        }
        catch (XPathException e) {
            throw new SaxonApiUncheckedException(e);
        }
    }

    public Sequence getUnderlyingValue() {
        return this.value;
    }
}

