/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import net.sf.saxon.om.CodedName;
import net.sf.saxon.om.FingerprintedNode;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pattern.QNameTest;
import net.sf.saxon.tree.tiny.TinyTree;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.z.IntSet;
import net.sf.saxon.z.IntSingletonSet;

public class NameTest
extends NodeTest
implements QNameTest {
    private int nodeKind;
    private int fingerprint;
    private NamePool namePool;
    private String uri = null;
    private String localName = null;

    public NameTest(int nodeKind, String uri, String localName, NamePool namePool) {
        this.nodeKind = nodeKind;
        this.fingerprint = namePool.allocate("", uri, localName) & 0xFFFFF;
        this.namePool = namePool;
    }

    public NameTest(int nodeKind, int nameCode, NamePool namePool) {
        this.nodeKind = nodeKind;
        this.fingerprint = nameCode & 0xFFFFF;
        this.namePool = namePool;
    }

    public NameTest(int nodeKind, NodeName name, NamePool pool) {
        this.nodeKind = nodeKind;
        this.fingerprint = name.allocateNameCode(pool) & 0xFFFFF;
        this.namePool = pool;
    }

    public NameTest(NodeInfo node) {
        this.nodeKind = node.getNodeKind();
        this.fingerprint = node.getFingerprint();
        this.namePool = node.getNamePool();
    }

    public NamePool getNamePool() {
        return this.namePool;
    }

    public int getNodeKind() {
        return this.nodeKind;
    }

    public NodeName getNodeName() {
        return new CodedName(this.fingerprint, this.namePool);
    }

    public boolean matches(int nodeKind, NodeName name, int annotation) {
        if (nodeKind != this.nodeKind) {
            return false;
        }
        if (name.hasFingerprint()) {
            return name.getFingerprint() == this.fingerprint;
        }
        this.computeUriAndLocal();
        return name.isInNamespace(this.uri) && name.getLocalPart().equals(this.localName);
    }

    public boolean matches(TinyTree tree, int nodeNr) {
        return (tree.getNameCode(nodeNr) & 0xFFFFF) == this.fingerprint && tree.getNodeKind(nodeNr) == this.nodeKind;
    }

    public boolean matches(NodeInfo node) {
        if (node.getNodeKind() != this.nodeKind) {
            return false;
        }
        if (node instanceof FingerprintedNode) {
            return node.getFingerprint() == this.fingerprint;
        }
        this.computeUriAndLocal();
        return this.localName.equals(node.getLocalPart()) && this.uri.equals(node.getURI());
    }

    private void computeUriAndLocal() {
        if (this.uri == null) {
            this.uri = this.namePool.getURI(this.fingerprint);
        }
        if (this.localName == null) {
            this.localName = this.namePool.getLocalName(this.fingerprint);
        }
    }

    public boolean matches(StructuredQName qname) {
        this.computeUriAndLocal();
        return qname.getLocalPart().equals(this.localName) && qname.getURI().equals(this.uri);
    }

    public final double getDefaultPriority() {
        return 0.0;
    }

    public int getFingerprint() {
        return this.fingerprint;
    }

    public int getPrimitiveType() {
        return this.nodeKind;
    }

    public ItemType getSuperType(TypeHierarchy th) {
        return NodeKindTest.makeNodeKindTest(this.nodeKind);
    }

    public int getNodeKindMask() {
        return 1 << this.nodeKind;
    }

    public IntSet getRequiredNodeNames() {
        return new IntSingletonSet(this.fingerprint);
    }

    public String getNamespaceURI() {
        this.computeUriAndLocal();
        return this.uri;
    }

    public String getLocalPart() {
        this.computeUriAndLocal();
        return this.localName;
    }

    public String toString() {
        switch (this.nodeKind) {
            case 1: {
                return "element(" + this.namePool.getEQName(this.fingerprint) + ")";
            }
            case 2: {
                return "attribute(" + this.namePool.getEQName(this.fingerprint) + ")";
            }
            case 7: {
                return "processing-instruction(" + this.namePool.getDisplayName(this.fingerprint) + ')';
            }
            case 13: {
                return "namespace-node(" + this.namePool.getDisplayName(this.fingerprint) + ')';
            }
        }
        return this.namePool.getDisplayName(this.fingerprint);
    }

    public int hashCode() {
        return this.nodeKind << 20 ^ this.fingerprint;
    }

    public boolean equals(Object other) {
        return other instanceof NameTest && ((NameTest)other).namePool == this.namePool && ((NameTest)other).nodeKind == this.nodeKind && ((NameTest)other).fingerprint == this.fingerprint;
    }
}

