/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.java;

import java.text.Collator;
import java.util.List;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.Platform;
import net.sf.saxon.dom.DOMEnvelope;
import net.sf.saxon.dom.DOMObjectModel;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.expr.sort.CodepointCollator;
import net.sf.saxon.expr.sort.SimpleCollation;
import net.sf.saxon.functions.FunctionLibraryList;
import net.sf.saxon.java.JavaCollationFactory;
import net.sf.saxon.lib.StandardCollectionURIResolver;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.regex.ARegularExpression;
import net.sf.saxon.regex.JavaRegularExpression;
import net.sf.saxon.regex.RegularExpression;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaPlatform
implements Platform {
    @Override
    public void initialize(Configuration config) {
        config.registerExternalObjectModel(DOMEnvelope.getInstance());
        config.registerExternalObjectModel(DOMObjectModel.getInstance());
        config.setCollectionURIResolver(new StandardCollectionURIResolver());
    }

    @Override
    public boolean isJava() {
        return true;
    }

    @Override
    public boolean isDotNet() {
        return false;
    }

    @Override
    public String getPlatformVersion() {
        return "Java version " + System.getProperty("java.version");
    }

    @Override
    public String getPlatformSuffix() {
        return "J";
    }

    @Override
    public XMLReader loadParser() {
        XMLReader parser;
        try {
            parser = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
        }
        catch (ParserConfigurationException err) {
            throw new TransformerFactoryConfigurationError(err);
        }
        catch (SAXException err) {
            throw new TransformerFactoryConfigurationError(err);
        }
        return parser;
    }

    @Override
    public Source getParserSource(PipelineConfiguration pipe, StreamSource input, int validation, boolean dtdValidation, int stripspace) {
        return input;
    }

    @Override
    public StringCollator makeCollation(Configuration config, Properties props, String uri) throws XPathException {
        return JavaCollationFactory.makeCollation(config, uri, props);
    }

    @Override
    public boolean canReturnCollationKeys(StringCollator collation) {
        return collation instanceof CodepointCollator || collation instanceof SimpleCollation && ((SimpleCollation)collation).getCollation() instanceof Collator;
    }

    @Override
    public Object getCollationKey(SimpleCollation namedCollation, String value) {
        return ((Collator)namedCollation.getCollation()).getCollationKey(value);
    }

    @Override
    public RegularExpression compileRegularExpression(CharSequence regex, String flags, String hostLanguage, List<String> warnings) throws XPathException {
        if (flags.endsWith("!")) {
            return new JavaRegularExpression(regex, flags.substring(0, flags.length() - 1));
        }
        return new ARegularExpression(regex, flags, hostLanguage, warnings);
    }

    public void addFunctionLibraries(FunctionLibraryList list, Configuration config, int hostLanguage) {
    }

    @Override
    public SchemaType getExternalObjectType(Configuration config, String uri, String localName) {
        throw new UnsupportedOperationException("getExternalObjectType for Java");
    }

    @Override
    public String getInstallationDirectory(String edition, Configuration config) {
        return System.getenv("SAXON_HOME");
    }

    @Override
    public void registerAllBuiltInObjectModels(Configuration config) {
    }

    @Override
    public void setDefaultSAXParserFactory() {
    }

    @Override
    public ClassLoader getClassLoaderForGeneratedClass(final String definedClassName, final byte[] classFile, Configuration config, Class thisClass) {
        ClassLoader parentClassLoader = config.getDynamicLoader().getClassLoader();
        if (parentClassLoader == null) {
            parentClassLoader = Thread.currentThread().getContextClassLoader();
        }
        if (parentClassLoader == null) {
            parentClassLoader = thisClass.getClassLoader();
        }
        return new ClassLoader(parentClassLoader){

            @Override
            protected Class<?> findClass(String name) throws ClassNotFoundException {
                if (name.equals(definedClassName)) {
                    return this.defineClass(name, classFile, 0, classFile.length);
                }
                return super.findClass(name);
            }
        };
    }
}

