/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.sort;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.expr.sort.ComparisonKey;
import net.sf.saxon.expr.sort.GroupIterator;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.om.AtomicArray;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.EmptyAtomicSequence;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.ListIterator;
import net.sf.saxon.tree.iter.LookaheadIterator;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.SequenceExtent;

public class GroupByIterator
implements GroupIterator,
LastPositionFinder,
LookaheadIterator {
    private SequenceIterator population;
    protected Expression keyExpression;
    private StringCollator collator;
    private XPathContext keyContext;
    private int position = 0;
    protected List<List<Item>> groups = new ArrayList<List<Item>>(40);
    protected List<AtomicSequence> groupKeys = new ArrayList<AtomicSequence>(40);
    protected AtomicComparer comparer;
    protected int groupSlot = -1;
    protected int keySlot = -1;
    protected boolean composite;

    public GroupByIterator(SequenceIterator population, Expression keyExpression, XPathContext keyContext, AtomicComparer comparer, boolean composite) throws XPathException {
        this.population = population;
        this.keyExpression = keyExpression;
        this.keyContext = keyContext;
        this.comparer = comparer;
        this.composite = composite;
        if (composite) {
            this.buildIndexedGroupsComposite();
        } else {
            this.buildIndexedGroups();
        }
    }

    public GroupByIterator() {
    }

    public void setGroupSlot(int groupSlot) {
        this.groupSlot = groupSlot;
    }

    public void setKeySlot(int keySlot) {
        this.keySlot = keySlot;
    }

    private void buildIndexedGroups() throws XPathException {
        Object item;
        HashMap index = new HashMap(40);
        XPathContextMinor c2 = this.keyContext.newMinorContext();
        c2.setCurrentIterator(this.population);
        while ((item = this.population.next()) != null) {
            AtomicValue key;
            SequenceIterator<? extends Item> keys = this.keyExpression.iterate(c2);
            boolean firstKey = true;
            while ((key = (AtomicValue)keys.next()) != null) {
                ComparisonKey comparisonKey = this.comparer.getComparisonKey(key);
                List g = (List)index.get(comparisonKey);
                if (g == null) {
                    ArrayList newGroup = new ArrayList(20);
                    newGroup.add(item);
                    this.groups.add(newGroup);
                    this.groupKeys.add(key);
                    index.put(comparisonKey, newGroup);
                } else if (firstKey) {
                    g.add(item);
                } else if (g.get(g.size() - 1) != item) {
                    g.add(item);
                }
                firstKey = false;
            }
        }
    }

    private void buildIndexedGroupsComposite() throws XPathException {
        Object item;
        HashMap index = new HashMap(40);
        XPathContextMinor c2 = this.keyContext.newMinorContext();
        c2.setCurrentIterator(this.population);
        while ((item = this.population.next()) != null) {
            AtomicValue key;
            SequenceIterator<? extends Item> keys = this.keyExpression.iterate(c2);
            ArrayList<ComparisonKey> ckList = new ArrayList<ComparisonKey>();
            ArrayList<AtomicValue> compositeKey = new ArrayList<AtomicValue>();
            while ((key = (AtomicValue)keys.next()) != null) {
                compositeKey.add(key);
                ComparisonKey comparisonKey = this.comparer.getComparisonKey(key);
                ckList.add(comparisonKey);
            }
            List g = (List)index.get(ckList);
            if (g == null) {
                ArrayList newGroup = new ArrayList(20);
                newGroup.add(item);
                this.groups.add(newGroup);
                this.groupKeys.add(new AtomicArray(compositeKey.toArray(new AtomicValue[compositeKey.size()])));
                index.put(ckList, newGroup);
                continue;
            }
            g.add(item);
        }
    }

    public synchronized AtomicSequence getCurrentGroupingKey() {
        AtomicSequence val = this.groupKeys.get(this.position - 1);
        if (val == null) {
            return EmptyAtomicSequence.getInstance();
        }
        return val;
    }

    public SequenceIterator iterateCurrentGroup() {
        return new ListIterator<Item>(this.groups.get(this.position - 1));
    }

    public boolean hasCurrentGroup() {
        return this.groupSlot < 0;
    }

    public boolean hasCurrentGroupingKey() {
        return this.keySlot < 0;
    }

    public List getCurrentGroup() {
        return this.groups.get(this.position - 1);
    }

    public boolean hasNext() {
        return this.position < this.groups.size();
    }

    public Item next() throws XPathException {
        if (this.position >= 0 && this.position < this.groups.size()) {
            if (this.groupSlot >= 0) {
                this.keyContext.setLocalVariable(this.groupSlot, new SequenceExtent<Item>(this.groups.get(this.position)));
            }
            if (this.keySlot >= 0) {
                this.keyContext.setLocalVariable(this.keySlot, this.groupKeys.get(this.position));
            }
            ++this.position;
            return this.current();
        }
        this.position = -1;
        return null;
    }

    public Item current() {
        if (this.position < 1) {
            return null;
        }
        return this.groups.get(this.position - 1).get(0);
    }

    public int position() {
        return this.position;
    }

    public void close() {
    }

    public SequenceIterator getAnother() throws XPathException {
        XPathContextMinor c2 = this.keyContext.newMinorContext();
        return new GroupByIterator(this.population.getAnother(), this.keyExpression, c2, this.comparer, this.composite);
    }

    public int getProperties() {
        return 6;
    }

    public int getLength() throws XPathException {
        return this.groups.size();
    }
}

