/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.parser;

import java.io.Serializable;
import javax.xml.transform.SourceLocator;
import net.sf.saxon.event.LocationProvider;
import net.sf.saxon.event.SaxonLocator;
import net.sf.saxon.expr.instruct.LocationMap;
import org.xml.sax.Locator;

public class ExpressionLocation
implements SaxonLocator,
Serializable {
    private String systemId;
    private int lineNumber;
    private int columnNumber = -1;

    public ExpressionLocation() {
    }

    public ExpressionLocation(SourceLocator loc) {
        this.systemId = loc.getSystemId();
        this.lineNumber = loc.getLineNumber();
        this.columnNumber = loc.getColumnNumber();
    }

    public static ExpressionLocation makeFromSax(Locator loc) {
        return new ExpressionLocation(loc.getSystemId(), loc.getLineNumber(), loc.getColumnNumber());
    }

    public ExpressionLocation(LocationProvider provider, long locationId) {
        this.systemId = provider.getSystemId(locationId);
        this.lineNumber = provider.getLineNumber(locationId);
        this.columnNumber = provider.getColumnNumber(locationId);
    }

    public ExpressionLocation(String systemId, int lineNumber, int columnNumber) {
        this.systemId = systemId;
        this.lineNumber = lineNumber;
        this.columnNumber = columnNumber;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public String getPublicId() {
        return null;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public void setColumnNumber(int columnNumber) {
        this.columnNumber = columnNumber;
    }

    public String getSystemId(long locationId) {
        return this.getSystemId();
    }

    public int getLineNumber(long locationId) {
        return this.getLineNumber();
    }

    public int getColumnNumber(long locationId) {
        return this.getColumnNumber();
    }

    public static SaxonLocator getSourceLocator(long locationId, LocationProvider locationProvider) {
        SaxonLocator locator;
        if (locationProvider instanceof LocationMap && locationId != 0L) {
            ExpressionLocation loc = new ExpressionLocation();
            loc.setLineNumber(locationProvider.getLineNumber(locationId));
            loc.setSystemId(locationProvider.getSystemId(locationId));
            locator = loc;
        } else if (locationProvider instanceof SaxonLocator) {
            locator = (SaxonLocator)locationProvider;
        } else {
            ExpressionLocation loc = new ExpressionLocation();
            loc.setLineNumber(locationProvider.getLineNumber(locationId));
            loc.setSystemId(locationProvider.getSystemId(locationId));
            locator = loc;
        }
        return locator;
    }
}

