/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.BindingReference;
import net.sf.saxon.expr.Container;
import net.sf.saxon.expr.ErrorExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.Bindery;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.expr.instruct.GeneralVariable;
import net.sf.saxon.expr.instruct.GlobalParam;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RoleLocator;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.query.Declaration;
import net.sf.saxon.query.XQueryFunction;
import net.sf.saxon.query.XQueryFunctionLibrary;
import net.sf.saxon.trace.InstructionInfo;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.tree.iter.UnfailingIterator;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.SingletonClosure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlobalVariable
extends GeneralVariable
implements Container,
Declaration,
InstructionInfo {
    protected List<BindingReference> references = new ArrayList<BindingReference>(10);
    private Executable executable;
    private SlotManager stackFrameMap = null;
    private boolean indexed;
    private int lineNumber;
    private String systemId;
    private boolean isPrivate = false;
    private boolean isAssignable = false;
    private GlobalVariable originalVariable;

    @Override
    public Executable getExecutable() {
        return this.executable;
    }

    public void setExecutable(Executable executable) {
        this.executable = executable;
    }

    public void setOriginalVariable(GlobalVariable var) {
        this.originalVariable = var;
    }

    public GlobalVariable getOriginalVariable() {
        return this.originalVariable;
    }

    public GlobalVariable getUltimateOriginalVariable() {
        if (this.originalVariable == null) {
            return this;
        }
        return this.originalVariable.getUltimateOriginalVariable();
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public int getLineNumber(long locationId) {
        return this.lineNumber;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    @Override
    public String getSystemId() {
        return this.systemId;
    }

    @Override
    public int getColumnNumber(long locationId) {
        return this.executable.getLocationMap().getLineNumber(locationId);
    }

    public boolean isPrivate() {
        return this.isPrivate;
    }

    public void setPrivate(boolean b) {
        this.isPrivate = b;
    }

    public void setAssignable(boolean assignable) {
        this.isAssignable = assignable;
    }

    @Override
    public final boolean isAssignable() {
        return this.isAssignable;
    }

    @Override
    public int getConstructType() {
        return 205;
    }

    @Override
    public StructuredQName getObjectName() {
        return this.getVariableQName();
    }

    @Override
    public Object getProperty(String name) {
        return null;
    }

    @Override
    public Iterator<String> getProperties() {
        List list = Collections.emptyList();
        return list.iterator();
    }

    @Override
    public Container getContainer() {
        return this;
    }

    @Override
    public int getHostLanguage() {
        return this.executable.getHostLanguage();
    }

    public void setIndexedVariable() {
        this.indexed = true;
    }

    public boolean isIndexedVariable() {
        return this.indexed;
    }

    @Override
    public int getContainerGranularity() {
        return 2;
    }

    public void setContainsLocals(SlotManager map) {
        this.stackFrameMap = map;
    }

    @Override
    public boolean isGlobal() {
        return true;
    }

    public void registerReference(BindingReference ref) {
        this.references.add(ref);
    }

    public Iterator iterateReferences() {
        return this.references.iterator();
    }

    public void compile(Executable exec, int slot) throws XPathException {
        if (this.references.isEmpty()) {
            return;
        }
        TypeHierarchy th = exec.getConfiguration().getTypeHierarchy();
        this.setSlotNumber(slot);
        if (this instanceof GlobalParam) {
            this.setRequiredParam(this.select == null);
        }
        SequenceType type = this.getRequiredType();
        for (BindingReference ref : this.references) {
            int relation;
            ref.fixup(this);
            GroundedValue constantValue = null;
            int properties = 0;
            Expression select = this.getSelectExpression();
            if (select instanceof Literal && !(this instanceof GlobalParam) && ((relation = th.relationship(select.getItemType(th), type.getPrimaryType())) == 0 || relation == 2)) {
                constantValue = ((Literal)select).getValue();
            }
            if (select != null) {
                properties = select.getSpecialProperties();
            }
            ref.setStaticType(type, constantValue, properties |= 0x400000);
        }
        exec.registerGlobalVariable(this);
        this.setReferenceCount(10);
    }

    public void typeCheck(ExpressionVisitor visitor) throws XPathException {
        Expression value = this.getSelectExpression();
        if (value != null) {
            value.checkForUpdatingSubexpressions();
            if (value.isUpdatingExpression()) {
                throw new XPathException("Initializing expression for global variable must not be an updating expression", "XUST0001");
            }
            value.setContainer(this);
            RoleLocator role = new RoleLocator(3, this.getVariableQName(), 0);
            ExpressionVisitor.ContextItemType cit = new ExpressionVisitor.ContextItemType(AnyItemType.getInstance(), true);
            Expression value2 = TypeChecker.strictTypeCheck(visitor.typeCheck(visitor.simplify(value), cit), this.getRequiredType(), role, visitor.getStaticContext());
            value2 = value2.optimize(visitor, cit);
            this.setSelectExpression(value2);
            value2.setContainer(this);
            SlotManager map = visitor.getConfiguration().makeSlotManager();
            int slots = ExpressionTool.allocateSlots(value2, 0, map);
            if (slots > 0) {
                this.setContainsLocals(map);
            }
            if (this.getRequiredType() == SequenceType.ANY_SEQUENCE && !(this instanceof GlobalParam)) {
                try {
                    TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
                    ItemType itemType = value.getItemType(th);
                    int cardinality = value.getCardinality();
                    this.setRequiredType(SequenceType.makeSequenceType(itemType, cardinality));
                    GroundedValue constantValue = null;
                    if (value2 instanceof Literal) {
                        constantValue = ((Literal)value2).getValue();
                    }
                    for (BindingReference reference : this.references) {
                        BindingReference ref = reference;
                        if (!(ref instanceof VariableReference)) continue;
                        ((VariableReference)ref).refineVariableType(itemType, cardinality, constantValue, value.getSpecialProperties(), visitor);
                    }
                }
                catch (Exception err) {
                    // empty catch block
                }
            }
        }
    }

    public void lookForCycles(Stack<Container> referees, XQueryFunctionLibrary globalFunctionLibrary) throws XPathException {
        if (referees.contains(this)) {
            int s = referees.indexOf(this);
            referees.push(this);
            String message = "Circular definition of global variable: ";
            message = this.getVariableQName().getLocalPart().equals("context-item") ? message + "Context item" : message + "$" + this.getVariableQName().getDisplayName();
            for (int i = s; i < referees.size() - 1; ++i) {
                InstructionInfo next;
                if (i != s) {
                    message = message + ", which";
                }
                if (referees.get(i + 1) instanceof GlobalVariable) {
                    next = (GlobalVariable)referees.get(i + 1);
                    if (((GeneralVariable)((Object)next)).getVariableQName().getLocalPart().equals("context-item")) {
                        message = message + " uses context item";
                        continue;
                    }
                    message = message + " uses $" + ((GeneralVariable)((Object)next)).getVariableQName().getDisplayName();
                    continue;
                }
                if (!(referees.get(i + 1) instanceof XQueryFunction)) continue;
                next = (XQueryFunction)referees.get(i + 1);
                message = message + " calls " + ((XQueryFunction)next).getFunctionName().getDisplayName() + "#" + ((XQueryFunction)next).getNumberOfArguments() + "()";
            }
            message = message + '.';
            XPathException err = new XPathException(message);
            String errorCode = this.getHostLanguage() == 50 ? "XTDE0640" : (this.executable.isAllowXPath30() ? "XQDY0054" : "XQST0054");
            err.setErrorCode(errorCode);
            err.setIsStaticError(true);
            err.setLocator(this);
            throw err;
        }
        if (this.select != null) {
            referees.push(this);
            ArrayList<Binding> list = new ArrayList<Binding>(10);
            ExpressionTool.gatherReferencedVariables(this.select, list);
            for (Binding b : list) {
                if (!(b instanceof GlobalVariable)) continue;
                ((GlobalVariable)b).lookForCycles(referees, globalFunctionLibrary);
            }
            ArrayList flist = new ArrayList();
            ExpressionTool.gatherCalledFunctionNames(this.select, flist);
            for (String s : flist) {
                XQueryFunction f = globalFunctionLibrary.getDeclarationByKey(s);
                if (referees.contains(f)) continue;
                GlobalVariable.lookForFunctionCycles(f, referees, globalFunctionLibrary);
            }
            referees.pop();
        }
    }

    private static void lookForFunctionCycles(XQueryFunction f, Stack<Container> referees, XQueryFunctionLibrary globalFunctionLibrary) throws XPathException {
        Expression body = f.getBody();
        referees.push(f);
        ArrayList<Binding> list = new ArrayList<Binding>(10);
        ExpressionTool.gatherReferencedVariables(body, list);
        for (Binding b : list) {
            if (!(b instanceof GlobalVariable)) continue;
            ((GlobalVariable)b).lookForCycles(referees, globalFunctionLibrary);
        }
        ArrayList flist = new ArrayList();
        ExpressionTool.gatherCalledFunctionNames(body, flist);
        for (String s : flist) {
            XQueryFunction qf = globalFunctionLibrary.getDeclarationByKey(s);
            if (referees.contains(qf)) continue;
            GlobalVariable.lookForFunctionCycles(qf, referees, globalFunctionLibrary);
        }
        referees.pop();
    }

    @Override
    public Sequence getSelectValue(XPathContext context) throws XPathException {
        if (this.select == null) {
            throw new AssertionError((Object)("*** No select expression for global variable $" + this.getVariableQName().getDisplayName() + "!!"));
        }
        try {
            XPathContextMajor c2 = context.newCleanContext();
            c2.setOrigin(this);
            Controller controller = c2.getController();
            assert (controller != null);
            UnfailingIterator<Item> initialNode = SingletonIterator.makeIterator(controller.getContextForGlobalVariables());
            initialNode.next();
            c2.setCurrentIterator(initialNode);
            if (this.stackFrameMap != null) {
                c2.openStackFrame(this.stackFrameMap);
            }
            return ExpressionTool.evaluate(this.select, this.evaluationMode, c2, this.referenceCount);
        }
        catch (XPathException e) {
            if (!this.getVariableQName().getURI().equals("http://saxon.sf.net/generated-global-variable")) {
                e.setIsGlobalError(true);
            }
            throw e;
        }
    }

    @Override
    public Sequence evaluateVariable(XPathContext context) throws XPathException {
        Controller controller = context.getController();
        assert (controller != null);
        Bindery b = controller.getBindery();
        Sequence v = b.getGlobalVariable(this.getSlotNumber());
        if (v != null) {
            return v;
        }
        return this.actuallyEvaluate(context);
    }

    protected Sequence actuallyEvaluate(XPathContext context) throws XPathException {
        Controller controller = context.getController();
        assert (controller != null);
        Bindery b = controller.getBindery();
        try {
            GlobalVariable.setDependencies(b, this, context);
            boolean go = b.setExecuting(this);
            if (!go) {
                return b.getGlobalVariable(this.getSlotNumber());
            }
            Sequence value = this.getSelectValue(context);
            if (this.indexed) {
                value = controller.getConfiguration().obtainOptimizer().makeIndexedValue(value.iterate());
            }
            return b.saveGlobalVariableValue(this, value);
        }
        catch (XPathException err) {
            b.setNotExecuting(this);
            if (err instanceof XPathException.Circularity) {
                String errorCode = this.getHostLanguage() == 50 ? "XTDE0640" : (this.executable.isAllowXPath30() ? "XQDY0054" : "XQST0054");
                err.setErrorCode(errorCode);
                err.setXPathContext(context);
                SingletonClosure closure = new SingletonClosure(new ErrorExpression(err), context);
                b.setGlobalVariable(this, closure);
                err.setLocator(this);
                throw err;
            }
            throw err;
        }
    }

    protected static void setDependencies(Bindery bindery, GlobalVariable var, XPathContext context) throws XPathException {
        if (!(context instanceof XPathContextMajor)) {
            context = GlobalVariable.getMajorCaller(context);
        }
        while (context != null) {
            do {
                InstructionInfo instructionInfo;
                if (!((instructionInfo = ((XPathContextMajor)context).getOrigin()) instanceof GlobalVariable)) continue;
                bindery.registerDependency((GlobalVariable)instructionInfo, var);
                return;
            } while ((context = GlobalVariable.getMajorCaller(context)) != null);
        }
    }

    private static XPathContextMajor getMajorCaller(XPathContext context) {
        XPathContext caller;
        for (caller = context.getCaller(); caller != null && !(caller instanceof XPathContextMajor); caller = caller.getCaller()) {
        }
        return (XPathContextMajor)caller;
    }
}

