/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.z;

import java.io.Serializable;
import net.sf.saxon.z.AbstractIntSet;
import net.sf.saxon.z.IntIterator;
import net.sf.saxon.z.IntRangeSet;
import net.sf.saxon.z.IntSet;

public class IntBlockSet
extends AbstractIntSet
implements Serializable,
IntSet {
    private int startPoint;
    private int endPoint;
    private int hashCode = -1;

    public IntBlockSet(int startPoint, int endPoint) {
        this.startPoint = startPoint;
        this.endPoint = endPoint;
    }

    public IntSet copy() {
        return this;
    }

    public IntSet mutableCopy() {
        return new IntRangeSet(new int[]{this.startPoint}, new int[]{this.endPoint});
    }

    public int size() {
        return this.endPoint - this.startPoint;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean contains(int value) {
        return value >= this.startPoint && value <= this.endPoint;
    }

    public boolean remove(int value) {
        throw new UnsupportedOperationException("remove");
    }

    public void clear() {
        throw new UnsupportedOperationException("clear");
    }

    public boolean add(int value) {
        throw new UnsupportedOperationException("add");
    }

    public IntIterator iterator() {
        return this.mutableCopy().iterator();
    }

    public String toString() {
        return this.startPoint + " - " + this.endPoint;
    }

    public boolean equals(Object other) {
        return this.mutableCopy().equals(other);
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            this.hashCode = 0x836A89F1 ^ this.startPoint + (this.endPoint << 3);
        }
        return this.hashCode;
    }

    public int getStartPoint() {
        return this.startPoint;
    }

    public int getEndPoint() {
        return this.endPoint;
    }
}

