/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.iter;

import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.LookaheadIterator;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.StringValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UntypedAtomizingIterator<B extends Item>
implements SequenceIterator<AtomicValue>,
LastPositionFinder<AtomicValue>,
LookaheadIterator<AtomicValue> {
    private SequenceIterator<B> base;
    private AtomicValue current = null;
    private int position = 0;

    public UntypedAtomizingIterator(SequenceIterator<B> base) {
        this.base = base;
    }

    @Override
    public AtomicValue next() throws XPathException {
        B nextSource = this.base.next();
        if (nextSource != null) {
            if (nextSource instanceof NodeInfo) {
                this.current = (AtomicValue)((NodeInfo)nextSource).atomize();
                ++this.position;
                return this.current;
            }
            if (nextSource instanceof AtomicValue) {
                return (AtomicValue)nextSource;
            }
            if (nextSource instanceof ObjectValue) {
                return StringValue.makeStringValue(nextSource.getStringValue());
            }
            throw new XPathException("The typed value of a function item is not defined", "FOTY0013");
        }
        this.current = null;
        this.position = -1;
        return null;
    }

    @Override
    public AtomicValue current() {
        return this.current;
    }

    @Override
    public int position() {
        return this.position;
    }

    @Override
    public void close() {
        this.base.close();
    }

    @Override
    public SequenceIterator<AtomicValue> getAnother() throws XPathException {
        return new UntypedAtomizingIterator<B>(this.base.getAnother());
    }

    @Override
    public int getProperties() {
        return this.base.getProperties() & 6;
    }

    @Override
    public int getLength() throws XPathException {
        return ((LastPositionFinder)((Object)this.base)).getLength();
    }

    @Override
    public boolean hasNext() {
        return ((LookaheadIterator)this.base).hasNext();
    }
}

