/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.AtomicSequenceConverter;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FirstItemExpression;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.expr.instruct.ValueOf;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.style.Declaration;
import net.sf.saxon.style.XSLLeafNodeConstructor;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Whitespace;

public final class XSLValueOf
extends XSLLeafNodeConstructor {
    private boolean disable = false;
    private Expression separator;

    protected ItemType getReturnedItemType() {
        return NodeKindTest.TEXT;
    }

    public void prepareAttributes() throws XPathException {
        String selectAtt = null;
        String disableAtt = null;
        String separatorAtt = null;
        AttributeCollection atts = this.getAttributeList();
        for (int a = 0; a < atts.getLength(); ++a) {
            String f = atts.getQName(a);
            if (f.equals("disable-output-escaping")) {
                disableAtt = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("select")) {
                selectAtt = atts.getValue(a);
                continue;
            }
            if (f.equals("separator")) {
                separatorAtt = atts.getValue(a);
                continue;
            }
            this.checkUnknownAttribute(atts.getNodeName(a));
        }
        if (selectAtt != null) {
            this.select = this.makeExpression(selectAtt);
        }
        if (separatorAtt != null) {
            this.separator = this.makeAttributeValueTemplate(separatorAtt);
        }
        if (disableAtt != null) {
            if (disableAtt.equals("yes")) {
                this.disable = true;
            } else if (disableAtt.equals("no")) {
                this.disable = false;
            } else {
                this.compileError("disable-output-escaping attribute must be either 'yes' or 'no'", "XTSE0020");
            }
        }
    }

    public void validate(Declaration decl) throws XPathException {
        if (this.select == null && this.iterateAxis((byte)3).next() == null && !this.isXslt30Processor()) {
            this.compileError("In XSLT 2.0, the xsl:value-of element must either have a select attribute, or have non-empty content", "XTSE0870");
        }
        super.validate(decl);
        this.select = this.typeCheck("select", this.select);
        this.separator = this.typeCheck("separator", this.separator);
    }

    protected String getErrorCodeForSelectPlusContent() {
        return "XTSE0870";
    }

    public Expression compile(Executable exec, Declaration decl) throws XPathException {
        TypeHierarchy th = this.getConfiguration().getTypeHierarchy();
        if (this.separator == null && this.select != null && this.xPath10ModeIsEnabled()) {
            if (!this.select.getItemType(th).isPlainType()) {
                this.select = Atomizer.makeAtomizer(this.select);
                this.select = this.makeExpressionVisitor().simplify(this.select);
            }
            if (Cardinality.allowsMany(this.select.getCardinality())) {
                this.select = FirstItemExpression.makeFirstItemExpression(this.select);
            }
            if (!th.isSubType(this.select.getItemType(th), BuiltInAtomicType.STRING)) {
                this.select = new AtomicSequenceConverter(this.select, BuiltInAtomicType.STRING);
                ((AtomicSequenceConverter)this.select).allocateConverter(this.getConfiguration(), false);
            }
        } else if (this.separator == null) {
            this.separator = this.select == null ? new StringLiteral(StringValue.EMPTY_STRING) : new StringLiteral(StringValue.SINGLE_SPACE);
        }
        ValueOf inst = new ValueOf(this.select, this.disable, false);
        this.compileContent(exec, decl, inst, this.separator);
        return inst;
    }
}

