/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.util.ArrayList;
import java.util.Iterator;
import net.sf.saxon.event.ComplexContentOutputter;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.SubExpressionInfo;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunctionCall;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Concat
extends SystemFunctionCall
implements Callable {
    @Override
    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        FastStringBuffer fsb = new FastStringBuffer(64);
        for (Sequence arg : arguments) {
            Item item = arg.head();
            if (item == null) continue;
            fsb.append(arg.head().getStringValueCS());
        }
        return new StringValue(fsb);
    }

    @Override
    protected SequenceType getRequiredType(int arg) {
        return this.getDetails().argumentTypes[0];
    }

    @Override
    public Iterator<SubExpressionInfo> iterateSubExpressionInfo() {
        ArrayList<SubExpressionInfo> list = new ArrayList<SubExpressionInfo>(this.argument.length);
        for (Expression anArgument : this.argument) {
            list.add(new SubExpressionInfo(anArgument, true, false, this.getDetails().syntacticContext[0]));
        }
        return list.iterator();
    }

    @Override
    public CharSequence evaluateAsString(XPathContext c) throws XPathException {
        return this.evaluateItem(c).getStringValueCS();
    }

    @Override
    public StringValue evaluateItem(XPathContext c) throws XPathException {
        int numArgs = this.argument.length;
        FastStringBuffer sb = new FastStringBuffer(64);
        for (int i = 0; i < numArgs; ++i) {
            AtomicValue val = (AtomicValue)this.argument[i].evaluateItem(c);
            if (val == null) continue;
            sb.append(val.getStringValueCS());
        }
        return StringValue.makeStringValue(sb.condense());
    }

    @Override
    public void process(XPathContext context) throws XPathException {
        SequenceReceiver out = context.getReceiver();
        if (out instanceof ComplexContentOutputter) {
            int numArgs = this.argument.length;
            out.append(StringValue.EMPTY_STRING, 0, 0);
            boolean empty = true;
            for (int i = 0; i < numArgs; ++i) {
                AtomicValue val = (AtomicValue)this.argument[i].evaluateItem(context);
                if (val == null) continue;
                out.characters(val.getStringValueCS(), 0, 0);
                empty = false;
            }
            if (!empty) {
                out.append(StringValue.EMPTY_STRING, 0, 0);
            }
        } else {
            out.append(this.evaluateItem(context), 0, 0);
        }
    }
}

