/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.tiny;

import net.sf.saxon.om.CodedName;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.AxisIteratorImpl;
import net.sf.saxon.tree.tiny.TinyTree;

final class AttributeEnumeration
extends AxisIteratorImpl {
    private TinyTree tree;
    private int element;
    private NodeTest nodeTest;
    private int index;
    private int currentNodeNr;

    AttributeEnumeration(TinyTree tree, int element, NodeTest nodeTest) {
        this.nodeTest = nodeTest;
        this.tree = tree;
        this.element = element;
        this.index = tree.alpha[element];
        this.currentNodeNr = -1;
    }

    public boolean moveNext() {
        while (true) {
            if (this.index >= this.tree.numberOfAttributes || this.tree.attParent[this.index] != this.element) {
                this.index = Integer.MAX_VALUE;
                this.current = null;
                this.position = -1;
                this.currentNodeNr = -1;
                return false;
            }
            int typeCode = this.tree.getAttributeAnnotation(this.index);
            if (this.nodeTest.matches(2, new CodedName(this.tree.attCode[this.index], this.tree.getNamePool()), typeCode)) {
                ++this.position;
                this.currentNodeNr = this.index++;
                if (this.nodeTest instanceof NameTest) {
                    this.index = Integer.MAX_VALUE;
                }
                this.current = null;
                return true;
            }
            ++this.index;
        }
    }

    public NodeInfo next() {
        this.current = this.moveNext() ? this.tree.getAttributeNode(this.currentNodeNr) : null;
        return this.current;
    }

    public NodeInfo current() {
        if (this.current == null) {
            if (this.currentNodeNr == -1) {
                return null;
            }
            this.current = this.tree.getAttributeNode(this.currentNodeNr);
        }
        return this.current;
    }

    public Sequence atomize() throws XPathException {
        if (this.currentNodeNr == -1) {
            throw new NullPointerException();
        }
        return this.tree.getTypedValueOfAttribute(null, this.currentNodeNr);
    }

    public CharSequence getStringValue() {
        if (this.currentNodeNr == -1) {
            throw new NullPointerException();
        }
        return this.tree.attValue[this.currentNodeNr];
    }

    public AxisIterator getAnother() {
        return new AttributeEnumeration(this.tree, this.element, this.nodeTest);
    }
}

