/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.z;

import net.sf.saxon.z.IntEmptySet;
import net.sf.saxon.z.IntHashSet;
import net.sf.saxon.z.IntIterator;
import net.sf.saxon.z.IntSet;

public class IntSingletonSet
implements IntSet {
    private int value;

    public IntSingletonSet(int value) {
        this.value = value;
    }

    public int getMember() {
        return this.value;
    }

    public void clear() {
        throw new UnsupportedOperationException("IntSingletonSet is immutable");
    }

    public IntSet copy() {
        return this;
    }

    public IntSet mutableCopy() {
        IntHashSet intHashSet = new IntHashSet();
        intHashSet.add(this.value);
        return intHashSet;
    }

    public int size() {
        return 1;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean contains(int value) {
        return this.value == value;
    }

    public boolean remove(int value) {
        throw new UnsupportedOperationException("IntSingletonSet is immutable");
    }

    public boolean add(int value) {
        throw new UnsupportedOperationException("IntSingletonSet is immutable");
    }

    public IntIterator iterator() {
        return new IntIterator(){
            boolean gone = false;

            public boolean hasNext() {
                return !this.gone;
            }

            public int next() {
                this.gone = true;
                return IntSingletonSet.this.value;
            }
        };
    }

    public IntSet union(IntSet other) {
        IntSet n = other.mutableCopy();
        n.add(this.value);
        return n;
    }

    public IntSet intersect(IntSet other) {
        if (other.contains(this.value)) {
            return this;
        }
        return IntEmptySet.getInstance();
    }

    public IntSet except(IntSet other) {
        if (other.contains(this.value)) {
            return IntEmptySet.getInstance();
        }
        return this;
    }

    public boolean containsAll(IntSet other) {
        if (other.size() > 1) {
            return false;
        }
        IntIterator ii = other.iterator();
        while (ii.hasNext()) {
            if (this.value == ii.next()) continue;
            return false;
        }
        return true;
    }
}

