/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.instruct.DocumentInstr;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.lib.Validation;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.style.Declaration;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.Whitespace;

public class XSLDocument
extends StyleElement {
    private int validationAction = 4;
    private SchemaType schemaType = null;

    public boolean isInstruction() {
        return true;
    }

    public boolean mayContainSequenceConstructor() {
        return true;
    }

    public void prepareAttributes() throws XPathException {
        AttributeCollection atts = this.getAttributeList();
        String validationAtt = null;
        String typeAtt = null;
        for (int a = 0; a < atts.getLength(); ++a) {
            String f = atts.getQName(a);
            if (f.equals("validation")) {
                validationAtt = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("type")) {
                typeAtt = Whitespace.trim(atts.getValue(a));
                continue;
            }
            this.checkUnknownAttribute(atts.getNodeName(a));
        }
        if (validationAtt == null) {
            this.validationAction = this.getContainingStylesheet().getDefaultValidation();
        } else {
            this.validationAction = Validation.getCode(validationAtt);
            if (this.validationAction != 4 && !this.getPreparedStylesheet().isSchemaAware()) {
                this.compileError("To perform validation, a schema-aware XSLT processor is needed", "XTSE1660");
            }
            if (this.validationAction == -1) {
                this.compileError("Invalid value of @validation attribute", "XTSE0020");
            }
        }
        if (typeAtt != null) {
            if (!this.getPreparedStylesheet().isSchemaAware()) {
                this.compileError("The @type attribute is available only with a schema-aware XSLT processor", "XTSE1660");
            }
            this.schemaType = this.getSchemaType(typeAtt);
            this.validationAction = 8;
        }
        if (typeAtt != null && validationAtt != null) {
            this.compileError("The @validation and @type attributes are mutually exclusive", "XTSE1505");
        }
    }

    public void validate(Declaration decl) throws XPathException {
    }

    public Expression compile(Executable exec, Declaration decl) throws XPathException {
        DocumentInstr inst = new DocumentInstr(false, null, this.getBaseURI());
        inst.setValidationAction(this.validationAction, this.schemaType);
        Expression b = this.compileSequenceConstructor(exec, decl, this.iterateAxis((byte)3), true);
        if (b == null) {
            b = Literal.makeEmptySequence();
        }
        inst.setContentExpression(b);
        return inst;
    }
}

