/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.sort;

import java.io.Serializable;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.expr.sort.ComparisonKey;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.trans.NoDynamicContextException;
import net.sf.saxon.value.AtomicValue;

public class DescendingComparer
implements AtomicComparer,
Serializable {
    private AtomicComparer baseComparer;

    public DescendingComparer(AtomicComparer base) {
        this.baseComparer = base;
    }

    public AtomicComparer getBaseComparer() {
        return this.baseComparer;
    }

    public StringCollator getCollator() {
        return this.baseComparer.getCollator();
    }

    public AtomicComparer provideContext(XPathContext context) {
        AtomicComparer newBase = this.baseComparer.provideContext(context);
        if (newBase != this.baseComparer) {
            return new DescendingComparer(newBase);
        }
        return this;
    }

    public int compareAtomicValues(AtomicValue a, AtomicValue b) throws NoDynamicContextException {
        return 0 - this.baseComparer.compareAtomicValues(a, b);
    }

    public boolean comparesEqual(AtomicValue a, AtomicValue b) throws NoDynamicContextException {
        return this.baseComparer.comparesEqual(a, b);
    }

    public ComparisonKey getComparisonKey(AtomicValue a) throws NoDynamicContextException {
        return this.baseComparer.getComparisonKey(a);
    }
}

