/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.xqj;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.Properties;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Result;
import javax.xml.transform.sax.SAXResult;
import javax.xml.xquery.XQConnection;
import javax.xml.xquery.XQException;
import javax.xml.xquery.XQItem;
import javax.xml.xquery.XQItemType;
import javax.xml.xquery.XQResultSequence;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.evpull.BracketedDocumentIterator;
import net.sf.saxon.evpull.Decomposer;
import net.sf.saxon.evpull.EventIterator;
import net.sf.saxon.evpull.EventIteratorOverSequence;
import net.sf.saxon.evpull.EventToStaxBridge;
import net.sf.saxon.functions.Insert;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.query.QueryResult;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.xqj.Closable;
import net.sf.saxon.xqj.SaxonXQItem;
import net.sf.saxon.xqj.SaxonXQPreparedExpression;
import net.sf.saxon.xqj.SaxonXQSequence;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;

public class SaxonXQForwardSequence
extends Closable
implements XQResultSequence {
    private SequenceIterator iterator;
    SaxonXQPreparedExpression expression;
    int position = 0;
    int lastReadPosition = Integer.MIN_VALUE;

    protected SaxonXQForwardSequence(SequenceIterator iterator, SaxonXQPreparedExpression expression) {
        this.iterator = iterator;
        this.expression = expression;
        this.setClosableContainer(expression);
    }

    SequenceIterator getCleanIterator() throws XPathException {
        return this.iterator.getAnother();
    }

    Configuration getConfiguration() {
        return this.expression.getConnection().getConfiguration();
    }

    public XQConnection getConnection() throws XQException {
        this.checkNotClosed();
        return this.expression.getConnection();
    }

    public String getAtomicValue() throws XQException {
        return this.getCurrentXQItem(true).getAtomicValue();
    }

    public boolean getBoolean() throws XQException {
        return this.getCurrentXQItem(true).getBoolean();
    }

    public byte getByte() throws XQException {
        return this.getCurrentXQItem(true).getByte();
    }

    public double getDouble() throws XQException {
        return this.getCurrentXQItem(true).getDouble();
    }

    public float getFloat() throws XQException {
        return this.getCurrentXQItem(true).getFloat();
    }

    public int getInt() throws XQException {
        return this.getCurrentXQItem(true).getInt();
    }

    public XMLStreamReader getItemAsStream() throws XQException {
        return this.getCurrentXQItem(true).getItemAsStream();
    }

    public String getItemAsString(Properties props) throws XQException {
        return this.getCurrentXQItem(true).getItemAsString(props);
    }

    public XQItemType getItemType() throws XQException {
        return this.getCurrentXQItem(false).getItemType();
    }

    public long getLong() throws XQException {
        return this.getCurrentXQItem(true).getLong();
    }

    public Node getNode() throws XQException {
        return this.getCurrentXQItem(true).getNode();
    }

    public URI getNodeUri() throws XQException {
        return this.getCurrentXQItem(false).getNodeUri();
    }

    public Object getObject() throws XQException {
        return this.getCurrentXQItem(true).getObject();
    }

    public short getShort() throws XQException {
        return this.getCurrentXQItem(true).getShort();
    }

    public boolean instanceOf(XQItemType type) throws XQException {
        return this.getCurrentXQItem(false).instanceOf(type);
    }

    public void writeItem(OutputStream os, Properties props) throws XQException {
        this.getCurrentXQItem(true).writeItem(os, props);
    }

    public void writeItem(Writer ow, Properties props) throws XQException {
        this.getCurrentXQItem(true).writeItem(ow, props);
    }

    public void writeItemToResult(Result result) throws XQException {
        this.getCurrentXQItem(true).writeItemToResult(result);
    }

    public void writeItemToSAX(ContentHandler saxHandler) throws XQException {
        this.getCurrentXQItem(true).writeItemToSAX(saxHandler);
    }

    public boolean absolute(int itempos) throws XQException {
        throw new XQException("Sequence is forwards-only");
    }

    public void afterLast() throws XQException {
        throw new XQException("Sequence is forwards-only");
    }

    public void beforeFirst() throws XQException {
        throw new XQException("Sequence is forwards-only");
    }

    public int count() throws XQException {
        throw new XQException("Sequence is forwards-only");
    }

    public boolean first() throws XQException {
        throw new XQException("Sequence is forwards-only");
    }

    public XQItem getItem() throws XQException {
        return this.getCurrentXQItem(true);
    }

    public int getPosition() throws XQException {
        throw new XQException("Sequence is forwards-only");
    }

    public XMLStreamReader getSequenceAsStream() throws XQException {
        this.checkNotClosed();
        this.checkOnlyReadOnce();
        EventIteratorOverSequence ei = new EventIteratorOverSequence(this.iterator);
        ei = new BracketedDocumentIterator((EventIterator)ei);
        Configuration config = this.getConfiguration();
        PipelineConfiguration pipe = config.makePipelineConfiguration();
        pipe.setHostLanguage(51);
        ei = new Decomposer((EventIterator)ei, pipe);
        return new EventToStaxBridge((EventIterator)ei, pipe);
    }

    public String getSequenceAsString(Properties props) throws XQException {
        this.checkNotClosed();
        StringWriter sw = new StringWriter();
        this.writeSequence(sw, props);
        return sw.toString();
    }

    public boolean isAfterLast() throws XQException {
        throw new XQException("Sequence is forwards-only");
    }

    public boolean isBeforeFirst() throws XQException {
        throw new XQException("Sequence is forwards-only");
    }

    public boolean isFirst() throws XQException {
        throw new XQException("Sequence is forwards-only");
    }

    public boolean isLast() throws XQException {
        throw new XQException("Sequence is forwards-only");
    }

    public boolean isOnItem() throws XQException {
        this.checkNotClosed();
        return this.position > 0;
    }

    public boolean isScrollable() throws XQException {
        this.checkNotClosed();
        return false;
    }

    public boolean last() throws XQException {
        throw new XQException("Sequence is forwards-only");
    }

    public boolean next() throws XQException {
        this.checkNotClosed();
        if (this.position < 0) {
            return false;
        }
        try {
            Item next = this.iterator.next();
            if (next == null) {
                this.position = -1;
                return false;
            }
            ++this.position;
            return true;
        }
        catch (XPathException e) {
            throw this.newXQException((Exception)((Object)e));
        }
    }

    public boolean previous() throws XQException {
        throw new XQException("Sequence is forwards-only");
    }

    public boolean relative(int itempos) throws XQException {
        this.checkNotClosed();
        throw new XQException("Sequence is forwards-only, cannot move backwards");
    }

    public void writeSequence(OutputStream os, Properties props) throws XQException {
        this.checkNotNull(os);
        this.checkNotClosed();
        this.checkOnlyReadOnce();
        if (props == null) {
            props = new Properties();
        }
        props = SaxonXQSequence.setDefaultProperties(props);
        SequenceIterator iter = this.iterator;
        if (this.isOnItem()) {
            iter = new Insert.InsertIterator((SequenceIterator)SingletonIterator.makeIterator((Item)iter.current()), iter, 0);
        }
        try {
            QueryResult.serializeSequence((SequenceIterator)iter, (Configuration)this.getConfiguration(), (OutputStream)os, (Properties)props);
        }
        catch (XPathException e) {
            throw this.newXQException((Exception)((Object)e));
        }
    }

    public void writeSequence(Writer ow, Properties props) throws XQException {
        this.checkNotClosed();
        this.checkNotNull(ow);
        this.checkOnlyReadOnce();
        if (props == null) {
            props = new Properties();
        } else {
            SaxonXQItem.validateSerializationProperties(props, this.expression.getConfiguration());
        }
        props = SaxonXQSequence.setDefaultProperties(props);
        PrintWriter pw = ow instanceof PrintWriter ? (PrintWriter)ow : new PrintWriter(ow);
        SequenceIterator iter = this.iterator;
        if (this.isOnItem()) {
            iter = new Insert.InsertIterator((SequenceIterator)SingletonIterator.makeIterator((Item)iter.current()), iter, 0);
        }
        try {
            QueryResult.serializeSequence((SequenceIterator)iter, (Configuration)this.getConfiguration(), (Writer)pw, (Properties)props);
        }
        catch (XPathException e) {
            throw this.newXQException((Exception)((Object)e));
        }
    }

    public void writeSequenceToResult(Result result) throws XQException {
        this.checkNotClosed();
        this.checkNotNull(result);
        this.checkOnlyReadOnce();
        Properties props = SaxonXQSequence.setDefaultProperties(null);
        try {
            QueryResult.serializeSequence((SequenceIterator)this.iterator, (Configuration)this.getConfiguration(), (Result)result, (Properties)props);
        }
        catch (XPathException e) {
            throw this.newXQException((Exception)((Object)e));
        }
    }

    public void writeSequenceToSAX(ContentHandler saxHandler) throws XQException {
        this.checkNotClosed();
        this.checkNotNull(saxHandler);
        this.writeSequenceToResult(new SAXResult(saxHandler));
    }

    private XQItem getCurrentXQItem(boolean onceOnly) throws XQException {
        this.checkNotClosed();
        if (this.position == 0) {
            throw new XQException("The XQSequence is positioned before the first item");
        }
        if (this.position < 0) {
            throw new XQException("The XQSequence is positioned after the last item");
        }
        if (onceOnly) {
            this.checkOnlyReadOnce();
        }
        SaxonXQItem item = new SaxonXQItem(this.iterator.current(), this.expression.getConnection());
        item.setClosableContainer(this);
        return item;
    }

    Item getSaxonItem() {
        return this.iterator.current();
    }

    private void checkNotNull(Object arg) throws XQException {
        if (arg == null) {
            throw new XQException("Argument is null");
        }
    }

    private void checkOnlyReadOnce() throws XQException {
        if (this.position == this.lastReadPosition) {
            throw new XQException("XQJ does not allow the same item to be read more than once");
        }
        this.lastReadPosition = this.position;
    }

    private XQException newXQException(Exception err) {
        XQException xqe = new XQException(err.getMessage());
        xqe.initCause((Throwable)err);
        return xqe;
    }
}

