/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunctionCall;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.NumericValue;

public class Insert
extends SystemFunctionCall
implements Callable {
    public SequenceIterator iterate(XPathContext context) throws XPathException {
        SequenceIterator<? extends Item> seq = this.argument[0].iterate(context);
        AtomicValue n0 = (AtomicValue)this.argument[1].evaluateItem(context);
        NumericValue n = (NumericValue)n0;
        int pos = (int)n.longValue();
        SequenceIterator<? extends Item> ins = this.argument[2].iterate(context);
        return new InsertIterator(seq, ins, pos);
    }

    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        NumericValue n = (NumericValue)arguments[1].head();
        int pos = (int)n.longValue();
        return SequenceTool.toLazySequence(new InsertIterator(arguments[0].iterate(), arguments[2].iterate(), pos));
    }

    public static class InsertIterator
    implements SequenceIterator {
        private SequenceIterator base;
        private SequenceIterator insert;
        private int insertPosition;
        private int position = 0;
        private Item current = null;
        private boolean inserting = false;

        public InsertIterator(SequenceIterator base, SequenceIterator insert, int insertPosition) {
            this.base = base;
            this.insert = insert;
            this.insertPosition = insertPosition < 1 ? 1 : insertPosition;
            this.inserting = insertPosition == 1;
        }

        public Item next() throws XPathException {
            Object nextItem;
            if (this.inserting) {
                nextItem = this.insert.next();
                if (nextItem == null) {
                    this.inserting = false;
                    nextItem = this.base.next();
                }
            } else if (this.position == this.insertPosition - 1) {
                nextItem = this.insert.next();
                if (nextItem == null) {
                    nextItem = this.base.next();
                } else {
                    this.inserting = true;
                }
            } else {
                nextItem = this.base.next();
                if (nextItem == null && this.position < this.insertPosition - 1) {
                    this.inserting = true;
                    nextItem = this.insert.next();
                }
            }
            if (nextItem == null) {
                this.current = null;
                this.position = -1;
                return null;
            }
            this.current = nextItem;
            ++this.position;
            return this.current;
        }

        public Item current() {
            return this.current;
        }

        public int position() {
            return this.position;
        }

        public void close() {
            this.base.close();
            this.insert.close();
        }

        public SequenceIterator getAnother() throws XPathException {
            return new InsertIterator(this.base.getAnother(), this.insert.getAnother(), this.insertPosition);
        }

        public int getProperties() {
            return 0;
        }
    }
}

