/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import net.sf.saxon.Controller;
import net.sf.saxon.PreparedStylesheet;
import net.sf.saxon.event.LocationProvider;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.StartTagBuffer;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.parser.ExpressionLocation;
import net.sf.saxon.expr.parser.ExpressionParser;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RoleLocator;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.style.UseWhenStaticContext;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Whitespace;

public class UseWhenFilter
extends ProxyReceiver {
    private StartTagBuffer startTag;
    private int depthOfHole = 0;
    private boolean emptyStylesheetElement = false;
    private Stack defaultNamespaceStack = new Stack();
    private DateTimeValue currentDateTime = DateTimeValue.getCurrentDateTime(null);
    private PreparedStylesheet preparedStylesheet;
    private Map<StructuredQName, GroundedValue> staticVariables;

    public UseWhenFilter(PreparedStylesheet preparedStylesheet, Receiver next) {
        super(next);
        this.preparedStylesheet = preparedStylesheet;
        this.staticVariables = new HashMap<StructuredQName, GroundedValue>();
    }

    public void setStartTagBuffer(StartTagBuffer startTag) {
        this.startTag = startTag;
    }

    public void open() throws XPathException {
        this.nextReceiver.open();
    }

    public void startElement(NodeName elemName, SchemaType typeCode, int locationId, int properties) throws XPathException {
        boolean inXsltNamespace = elemName.isInNamespace("http://www.w3.org/1999/XSL/Transform");
        String stdAttUri = inXsltNamespace ? "" : "http://www.w3.org/1999/XSL/Transform";
        this.defaultNamespaceStack.push(this.startTag.getAttribute(stdAttUri, "xpath-default-namespace"));
        if (this.emptyStylesheetElement) {
            ++this.depthOfHole;
            return;
        }
        if (this.depthOfHole == 0) {
            LocationProvider lp;
            block22: {
                String version;
                boolean isStylesheetElement;
                lp = this.getPipelineConfiguration().getLocationProvider();
                String useWhen = this.startTag.getAttribute(stdAttUri, "use-when");
                boolean bl = isStylesheetElement = inXsltNamespace && (elemName.getLocalPart().equals("stylesheet") || elemName.getLocalPart().equals("transform"));
                if (isStylesheetElement && "3.0".equals(version = this.startTag.getAttribute("", "version"))) {
                    this.preparedStylesheet.setHostLanguage(50, true);
                }
                if (useWhen != null) {
                    try {
                        boolean use = this.evaluateUseWhen(useWhen, lp.getLineNumber(locationId));
                        if (use) break block22;
                        if (isStylesheetElement) {
                            this.emptyStylesheetElement = true;
                            break block22;
                        }
                        this.depthOfHole = 1;
                        return;
                    }
                    catch (XPathException e) {
                        XPathException err = this.createXPathException("Error in use-when expression. " + e.getMessage(), e.getErrorCodeLocalPart(), lp, locationId);
                        err.setErrorCodeQName(e.getErrorCodeQName());
                        throw err;
                    }
                }
            }
            if (inXsltNamespace && this.preparedStylesheet.isAllowXPath30()) {
                boolean isVariable = elemName.getLocalPart().equals("variable");
                boolean isParam = elemName.getLocalPart().equals("param");
                if ((isVariable || isParam) && this.defaultNamespaceStack.size() == 2 && "yes".equals(Whitespace.trim(this.startTag.getAttribute("", "static")))) {
                    boolean isSupplied;
                    StructuredQName varName;
                    String nameStr = this.startTag.getAttribute("", "name");
                    String asStr = this.startTag.getAttribute("", "as");
                    boolean isRequired = "yes".equals(Whitespace.trim(this.startTag.getAttribute("", "required")));
                    UseWhenStaticContext staticContext = new UseWhenStaticContext(this.getConfiguration(), this.startTag, this.staticVariables);
                    SequenceType requiredType = SequenceType.ANY_SEQUENCE;
                    if (asStr != null) {
                        ExpressionParser parser = new ExpressionParser();
                        requiredType = parser.parseSequenceType(asStr, staticContext);
                    }
                    try {
                        varName = StructuredQName.fromLexicalQName(nameStr, false, true, this.getConfiguration().getNameChecker(), this.startTag);
                    }
                    catch (XPathException err) {
                        throw this.createXPathException("Invalid variable name:" + nameStr + ". " + err.getMessage(), err.getErrorCodeLocalPart(), lp, locationId);
                    }
                    boolean bl = isSupplied = isParam && this.preparedStylesheet.getCompilerInfo().getParameters().containsKey(varName);
                    if (isParam) {
                        if (isRequired && !isSupplied) {
                            throw this.createXPathException("No value was supplied for the required static parameter " + varName.getDisplayName(), "XTDE0050", lp, locationId);
                        }
                        if (isSupplied) {
                            Sequence suppliedValue = this.preparedStylesheet.getCompilerInfo().getParameters().convertParameterValue(varName, requiredType, true, staticContext.makeEarlyEvaluationContext());
                            this.staticVariables.put(varName, SequenceTool.toGroundedValue(suppliedValue));
                        }
                    }
                    if (isVariable || !isSupplied) {
                        Sequence value;
                        String selectStr = this.startTag.getAttribute("", "select");
                        if (selectStr == null) {
                            if (isVariable) {
                                throw this.createXPathException("The select attribute is required for a static global variable", "XTSE0010", lp, locationId);
                            }
                            value = EmptySequence.getInstance();
                            this.staticVariables.put(varName, EmptySequence.getInstance());
                        } else {
                            try {
                                value = this.evaluateStatic(selectStr, lp.getLineNumber(locationId));
                            }
                            catch (XPathException e) {
                                throw this.createXPathException("Error in " + elemName.getLocalPart() + " expression. " + e.getMessage(), e.getErrorCodeLocalPart(), lp, locationId);
                            }
                        }
                        ExpressionLocation locator = new ExpressionLocation(lp, locationId);
                        RoleLocator role = new RoleLocator(3, varName, 0);
                        TypeHierarchy th = this.getConfiguration().getTypeHierarchy();
                        value = th.applyFunctionConversionRules(value, requiredType, role, locator);
                        this.staticVariables.put(varName, SequenceTool.toGroundedValue(value));
                    }
                }
            }
            this.nextReceiver.startElement(elemName, typeCode, locationId, properties);
        } else {
            ++this.depthOfHole;
        }
    }

    public XPathException createXPathException(String message, String errorCode, LocationProvider lp, int locationId) throws XPathException {
        XPathException err = new XPathException(message);
        err.setErrorCode(errorCode);
        err.setIsStaticError(true);
        ExpressionLocation loc = new ExpressionLocation();
        loc.setSystemId(lp.getSystemId(locationId));
        loc.setLineNumber(lp.getLineNumber(locationId));
        err.setLocator(loc);
        try {
            this.getPipelineConfiguration().getErrorListener().fatalError(err);
        }
        catch (TransformerException tex) {
            throw XPathException.makeXPathException(tex);
        }
        err.setHasBeenReported(true);
        return err;
    }

    public void namespace(NamespaceBinding namespaceBinding, int properties) throws XPathException {
        if (this.depthOfHole == 0) {
            this.nextReceiver.namespace(namespaceBinding, properties);
        }
    }

    public void attribute(NodeName attName, SimpleType typeCode, CharSequence value, int locationId, int properties) throws XPathException {
        if (this.depthOfHole == 0) {
            this.nextReceiver.attribute(attName, typeCode, value, locationId, properties);
        }
    }

    public void startContent() throws XPathException {
        if (this.depthOfHole == 0) {
            this.nextReceiver.startContent();
        }
    }

    public void endElement() throws XPathException {
        this.defaultNamespaceStack.pop();
        if (this.depthOfHole > 0) {
            --this.depthOfHole;
        } else {
            this.nextReceiver.endElement();
        }
    }

    public void characters(CharSequence chars, int locationId, int properties) throws XPathException {
        if (this.depthOfHole == 0) {
            this.nextReceiver.characters(chars, locationId, properties);
        }
    }

    public void processingInstruction(String target, CharSequence data, int locationId, int properties) {
    }

    public void comment(CharSequence chars, int locationId, int properties) throws XPathException {
    }

    public boolean evaluateUseWhen(String expression, int locationId) throws XPathException {
        UseWhenStaticContext staticContext = new UseWhenStaticContext(this.getConfiguration(), this.startTag, this.staticVariables);
        LocationProvider lp = this.getPipelineConfiguration().getLocationProvider();
        staticContext.setBaseURI(lp.getSystemId(locationId));
        staticContext.setDefaultElementNamespace("");
        for (int i = this.defaultNamespaceStack.size() - 1; i >= 0; --i) {
            String uri = (String)this.defaultNamespaceStack.get(i);
            if (uri == null) continue;
            staticContext.setDefaultElementNamespace(uri);
            break;
        }
        Expression expr = ExpressionTool.make(expression, staticContext, staticContext, 0, 0, lp.getLineNumber(locationId), null);
        expr.setContainer(staticContext);
        ItemType contextItemType = Type.ITEM_TYPE;
        ExpressionVisitor.ContextItemType cit = new ExpressionVisitor.ContextItemType(contextItemType, true);
        ExpressionVisitor visitor = ExpressionVisitor.make(staticContext, staticContext.getExecutable());
        expr = visitor.typeCheck(expr, cit);
        SlotManager stackFrameMap = this.getPipelineConfiguration().getConfiguration().makeSlotManager();
        ExpressionTool.allocateSlots(expr, stackFrameMap.getNumberOfVariables(), stackFrameMap);
        Controller controller = new Controller(this.getConfiguration());
        controller.setURIResolver(new URIPreventer());
        controller.setCurrentDateTime(this.currentDateTime);
        XPathContextMajor dynamicContext = controller.newXPathContext();
        dynamicContext = dynamicContext.newCleanContext();
        dynamicContext.openStackFrame(stackFrameMap);
        return expr.effectiveBooleanValue(dynamicContext);
    }

    public Sequence evaluateStatic(String expression, int locationId) throws XPathException {
        UseWhenStaticContext staticContext = new UseWhenStaticContext(this.getConfiguration(), this.startTag, this.staticVariables);
        LocationProvider lp = this.getPipelineConfiguration().getLocationProvider();
        staticContext.setBaseURI(lp.getSystemId(locationId));
        staticContext.setDefaultElementNamespace("");
        for (int i = this.defaultNamespaceStack.size() - 1; i >= 0; --i) {
            String uri = (String)this.defaultNamespaceStack.get(i);
            if (uri == null) continue;
            staticContext.setDefaultElementNamespace(uri);
            break;
        }
        Expression expr = ExpressionTool.make(expression, staticContext, staticContext, 0, 0, lp.getLineNumber(locationId), null);
        expr.setContainer(staticContext);
        ItemType contextItemType = Type.ITEM_TYPE;
        ExpressionVisitor.ContextItemType cit = new ExpressionVisitor.ContextItemType(contextItemType, true);
        ExpressionVisitor visitor = ExpressionVisitor.make(staticContext, staticContext.getExecutable());
        expr = visitor.typeCheck(expr, cit);
        SlotManager stackFrameMap = this.getPipelineConfiguration().getConfiguration().makeSlotManager();
        ExpressionTool.allocateSlots(expr, stackFrameMap.getNumberOfVariables(), stackFrameMap);
        Controller controller = new Controller(this.getConfiguration());
        controller.setURIResolver(new URIPreventer());
        controller.setCurrentDateTime(this.currentDateTime);
        XPathContextMajor dynamicContext = controller.newXPathContext();
        dynamicContext = dynamicContext.newCleanContext();
        dynamicContext.openStackFrame(stackFrameMap);
        return SequenceExtent.makeSequenceExtent(expr.iterate(dynamicContext));
    }

    private static class URIPreventer
    implements URIResolver {
        private URIPreventer() {
        }

        public Source resolve(String href, String base) throws TransformerException {
            throw new TransformerException("No external documents are available within an [xsl]use-when expression");
        }
    }
}

