/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.functions.SystemFunctionCall;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.StringValue;

public class QNameFn
extends SystemFunctionCall {
    public Expression preEvaluate(ExpressionVisitor visitor) throws XPathException {
        try {
            XPathContext early = visitor.getStaticContext().makeEarlyEvaluationContext();
            Item item1 = this.argument[1].evaluateItem(early);
            String lex = item1.getStringValue();
            Item item0 = this.argument[0].evaluateItem(early);
            String uri = item0 == null ? "" : item0.getStringValue();
            NameChecker checker = visitor.getConfiguration().getNameChecker();
            String[] parts = checker.getQNameParts(lex);
            if (parts[0].length() != 0 && !checker.isValidNCName(parts[0])) {
                XPathException err = new XPathException("Malformed prefix in QName: '" + parts[0] + '\'');
                err.setErrorCode("FOCA0002");
                throw err;
            }
            return Literal.makeLiteral(new QNameValue(parts[0], uri, parts[1], BuiltInAtomicType.QNAME, checker));
        }
        catch (QNameException e) {
            XPathException err = new XPathException(e.getMessage(), this);
            err.setErrorCode("FOCA0002");
            err.setLocator(this);
            throw err;
        }
        catch (XPathException err) {
            if (err.getErrorCodeLocalPart().equals("FORG0001")) {
                err.setErrorCode("FOCA0002");
            }
            err.maybeSetLocation(this);
            throw err;
        }
    }

    public QNameValue evaluateItem(XPathContext context) throws XPathException {
        StringValue arg0 = (StringValue)this.argument[0].evaluateItem(context);
        StringValue arg1 = (StringValue)this.argument[1].evaluateItem(context);
        return this.expandedQName(arg0, arg1, context.getConfiguration().getNameChecker());
    }

    public QNameValue expandedQName(StringValue namespace, StringValue lexical, NameChecker checker) throws XPathException {
        String uri = namespace == null ? null : namespace.getStringValue();
        try {
            String lex = lexical.getStringValue();
            String[] parts = checker.getQNameParts(lex);
            if (parts[0].length() != 0 && !checker.isValidNCName(parts[0])) {
                XPathException err = new XPathException("Malformed prefix in QName: '" + parts[0] + '\'');
                err.setErrorCode("FOCA0002");
                throw err;
            }
            return new QNameValue(parts[0], uri, parts[1], BuiltInAtomicType.QNAME, checker);
        }
        catch (QNameException e) {
            throw new XPathException(e.getMessage(), "FOCA0002");
        }
        catch (XPathException err) {
            if (err.getErrorCodeLocalPart().equals("FORG0001")) {
                err.setErrorCode("FOCA0002");
            }
            err.maybeSetLocation(this);
            throw err;
        }
    }

    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        return this.expandedQName((StringValue)arguments[0].head(), (StringValue)arguments[1].head(), context.getConfiguration().getNameChecker());
    }
}

