/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.iter;

import java.util.List;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.tree.iter.GroundedIterator;
import net.sf.saxon.tree.iter.LookaheadIterator;
import net.sf.saxon.tree.iter.UnfailingIterator;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.SingletonItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListIterator<T extends Item>
implements UnfailingIterator<T>,
LastPositionFinder<T>,
LookaheadIterator<T>,
GroundedIterator<T> {
    int index = 0;
    int length;
    T current = null;
    List<T> list;

    public ListIterator(List<T> list) {
        this.list = list;
        this.length = list.size();
    }

    public ListIterator(List<T> list, int length) {
        this.list = list;
        this.length = length;
    }

    @Override
    public boolean hasNext() {
        return this.index < this.length;
    }

    @Override
    public T next() {
        if (this.index >= this.length) {
            this.current = null;
            this.index = -1;
            this.length = -1;
            return null;
        }
        this.current = (Item)this.list.get(this.index++);
        return this.current;
    }

    @Override
    public T current() {
        return this.current;
    }

    @Override
    public int position() {
        return this.index;
    }

    @Override
    public void close() {
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public ListIterator<T> getAnother() {
        return new ListIterator<T>(this.list);
    }

    @Override
    public int getProperties() {
        return 7;
    }

    @Override
    public GroundedValue materialize() {
        if (this.length == 0) {
            return EmptySequence.getInstance();
        }
        if (this.length == 1) {
            Item item = (Item)this.list.get(0);
            if (item instanceof GroundedValue) {
                return (GroundedValue)((Object)item);
            }
            return new SingletonItem<Item>(item);
        }
        return new SequenceExtent<T>(this.list);
    }
}

