/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.expr.Container;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.query.XQueryFunction;
import net.sf.saxon.query.XQueryFunctionBinder;
import net.sf.saxon.trans.XPathException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionLibraryList
implements FunctionLibrary,
XQueryFunctionBinder {
    public List<FunctionLibrary> libraryList = new ArrayList<FunctionLibrary>(8);

    public int addFunctionLibrary(FunctionLibrary lib) {
        this.libraryList.add(lib);
        return this.libraryList.size() - 1;
    }

    public FunctionLibrary get(int n) {
        return this.libraryList.get(n);
    }

    @Override
    public boolean isAvailable(StructuredQName functionName, int arity) {
        for (FunctionLibrary lib : this.libraryList) {
            if (!lib.isAvailable(functionName, arity)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Expression bind(StructuredQName functionName, int arity, Expression[] staticArgs, StaticContext env, Container container) throws XPathException {
        boolean debug = env.getConfiguration().getBooleanProperty("http://saxon.sf.net/feature/trace-external-functions");
        PrintStream err = env.getConfiguration().getStandardErrorOutput();
        if (debug) {
            err.println("Looking for function " + functionName.getClarkName());
        }
        for (FunctionLibrary lib : this.libraryList) {
            Expression func;
            if (debug) {
                err.println("Trying " + lib.getClass().getName());
            }
            if ((func = lib.bind(functionName, arity, staticArgs, env, container)) == null) continue;
            return func;
        }
        if (debug) {
            err.println("Function " + functionName.getClarkName() + " not found!");
        }
        return null;
    }

    @Override
    public XQueryFunction getDeclaration(StructuredQName functionName, Expression[] staticArgs) {
        for (FunctionLibrary lib : this.libraryList) {
            XQueryFunction func;
            if (!(lib instanceof XQueryFunctionBinder) || (func = ((XQueryFunctionBinder)lib).getDeclaration(functionName, staticArgs)) == null) continue;
            return func;
        }
        return null;
    }

    public List<FunctionLibrary> getLibraryList() {
        return this.libraryList;
    }

    @Override
    public FunctionLibrary copy() {
        FunctionLibraryList fll = new FunctionLibraryList();
        fll.libraryList = new ArrayList<FunctionLibrary>(this.libraryList.size());
        for (int i = 0; i < this.libraryList.size(); ++i) {
            fll.libraryList.add(this.libraryList.get(i).copy());
        }
        return fll;
    }
}

