/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.linked;

import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.LookaheadIterator;
import net.sf.saxon.tree.linked.NodeImpl;

abstract class TreeEnumeration
implements AxisIterator,
LookaheadIterator {
    protected NodeImpl start;
    protected NodeImpl next;
    protected NodeTest nodeTest;
    protected NodeImpl current = null;
    protected int position = 0;

    public TreeEnumeration(NodeImpl origin, NodeTest nodeTest) {
        this.next = origin;
        this.start = origin;
        this.nodeTest = nodeTest;
    }

    protected boolean conforms(NodeImpl node) {
        return node == null || this.nodeTest == null || this.nodeTest.matches(node);
    }

    protected final void advance() {
        do {
            this.step();
        } while (!this.conforms(this.next));
    }

    protected abstract void step();

    public boolean hasNext() {
        return this.next != null;
    }

    public boolean moveNext() {
        return this.next() != null;
    }

    public final NodeInfo next() {
        if (this.next == null) {
            this.current = null;
            this.position = -1;
            return null;
        }
        this.current = this.next;
        ++this.position;
        this.advance();
        return this.current;
    }

    public final NodeInfo current() {
        return this.current;
    }

    public final int position() {
        return this.position;
    }

    public void close() {
    }

    public AxisIterator iterateAxis(byte axis, NodeTest test) {
        return this.current.iterateAxis(axis, test);
    }

    public Sequence atomize() throws XPathException {
        return this.current.atomize();
    }

    public CharSequence getStringValue() {
        return this.current.getStringValueCS();
    }

    public int getProperties() {
        return 4;
    }
}

