/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.MalformedInputException;
import java.nio.charset.UnmappableCharacterException;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.functions.EscapeURI;
import net.sf.saxon.functions.ResolveURI;
import net.sf.saxon.functions.SystemFunctionCall;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.serialize.charcode.UTF16CharacterSet;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.value.StringValue;

public class UnparsedText
extends SystemFunctionCall
implements Callable {
    String expressionBaseURI = null;

    public void checkArguments(ExpressionVisitor visitor) throws XPathException {
        if (this.expressionBaseURI == null) {
            super.checkArguments(visitor);
            this.expressionBaseURI = visitor.getStaticContext().getBaseURI();
        }
    }

    public String getExpressionBaseURI() {
        return this.expressionBaseURI;
    }

    public Expression preEvaluate(ExpressionVisitor visitor) {
        return this;
    }

    public int computeSpecialProperties() {
        return super.computeSpecialProperties() & 0xFFBFFFFF;
    }

    public Item evaluateItem(XPathContext context) throws XPathException {
        StringValue hrefVal = (StringValue)this.argument[0].evaluateItem(context);
        String encoding = this.getNumberOfArguments() == 2 ? this.argument[1].evaluateItem(context).getStringValue() : null;
        return this.evalUnparsedText(hrefVal, encoding, context);
    }

    private static String getErrorCodePrefix(XPathContext context) {
        try {
            if (context.getController().getExecutable().isAllowXPath30()) {
                return "FOUT";
            }
            return "XTDE";
        }
        catch (Exception e) {
            return "XTDE";
        }
    }

    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        StringValue hrefVal = (StringValue)arguments[0].head();
        String encoding = this.getNumberOfArguments() == 2 ? arguments[1].head().getStringValue() : null;
        return this.evalUnparsedText(hrefVal, encoding, context);
    }

    public Item evalUnparsedText(StringValue hrefVal, String encoding, XPathContext context) throws XPathException {
        StringValue result;
        try {
            if (hrefVal == null) {
                return null;
            }
            String href = hrefVal.getStringValue();
            CharSequence content = this.readFile(href, this.expressionBaseURI, encoding, context);
            result = new StringValue(content);
        }
        catch (XPathException err) {
            err.maybeSetErrorCode(UnparsedText.getErrorCodePrefix(context) + "1170");
            throw err;
        }
        return result;
    }

    public CharSequence readFile(String href, String baseURI, String encoding, XPathContext context) throws XPathException {
        Reader reader;
        Configuration config = context.getConfiguration();
        NameChecker checker = config.getNameChecker();
        URI absoluteURI = UnparsedText.getAbsoluteURI(href, baseURI, context);
        try {
            reader = context.getController().getUnparsedTextURIResolver().resolve(absoluteURI, encoding, config);
        }
        catch (XPathException err) {
            err.maybeSetErrorCode(UnparsedText.getErrorCodePrefix(context) + "1170");
            err.maybeSetLocation(this);
            throw err;
        }
        try {
            return UnparsedText.readFile(checker, reader, context);
        }
        catch (UnsupportedEncodingException encErr) {
            XPathException e = new XPathException("Unknown encoding " + Err.wrap(encoding), encErr);
            e.setErrorCode(UnparsedText.getErrorCodePrefix(context) + "1190");
            throw e;
        }
        catch (IOException ioErr) {
            XPathException e = UnparsedText.handleIOError(absoluteURI, ioErr, context);
            e.setLocator(this);
            throw e;
        }
    }

    public static URI getAbsoluteURI(String href, String baseURI, XPathContext context) throws XPathException {
        URI absoluteURI;
        try {
            absoluteURI = ResolveURI.makeAbsolute(href, baseURI);
        }
        catch (URISyntaxException err) {
            XPathException e = new XPathException(err.getReason() + ": " + err.getInput(), err);
            e.setErrorCode(UnparsedText.getErrorCodePrefix(context) + "1170");
            throw e;
        }
        if (absoluteURI.getFragment() != null) {
            XPathException e = new XPathException("URI for unparsed-text() must not contain a fragment identifier");
            e.setErrorCode(UnparsedText.getErrorCodePrefix(context) + "1170");
            throw e;
        }
        EscapeURI.checkPercentEncoding(absoluteURI.toString());
        return absoluteURI;
    }

    public static XPathException handleIOError(URI absoluteURI, IOException ioErr, XPathContext context) {
        String message = "Failed to read input file";
        if (absoluteURI != null && !ioErr.getMessage().equals(absoluteURI.toString())) {
            message = message + ' ' + absoluteURI.toString();
        }
        message = message + " (" + ioErr.getClass().getName() + ')';
        XPathException e = new XPathException(message, ioErr);
        String errorCode = "FOUT1200";
        if (context != null) {
            errorCode = ioErr instanceof MalformedInputException ? UnparsedText.getErrorCodePrefix(context) + "1200" : (ioErr instanceof CharacterCodingException ? UnparsedText.getErrorCodePrefix(context) + "1200" : (ioErr instanceof UnmappableCharacterException ? UnparsedText.getErrorCodePrefix(context) + "1190" : UnparsedText.getErrorCodePrefix(context) + "1170"));
        }
        e.setErrorCode(errorCode);
        return e;
    }

    public static CharSequence readFile(NameChecker checker, Reader reader, XPathContext context) throws IOException, XPathException {
        int actual;
        FastStringBuffer sb = new FastStringBuffer(1024);
        char[] buffer = new char[2048];
        boolean first = true;
        int line = 1;
        int column = 1;
        while ((actual = reader.read(buffer, 0, 2048)) >= 0) {
            int c = 0;
            while (c < actual) {
                int ch32;
                if ((ch32 = buffer[c++]) == 10) {
                    ++line;
                    column = 0;
                }
                ++column;
                if (UTF16CharacterSet.isHighSurrogate(ch32)) {
                    if (c == actual) {
                        actual = reader.read(buffer, 0, 2048);
                        c = 0;
                    }
                    char low = buffer[c++];
                    ch32 = UTF16CharacterSet.combinePair((char)ch32, low);
                }
                if (checker.isValidChar(ch32)) continue;
                XPathException err = new XPathException("The unparsed-text file contains a character that is illegal in XML (line=" + line + " column=" + column + " value=hex " + Integer.toHexString(ch32) + ')');
                err.setErrorCode(UnparsedText.getErrorCodePrefix(context) + "1190");
                throw err;
            }
            if (first) {
                first = false;
                if (buffer[0] == '\ufeff') {
                    sb.append(buffer, 1, actual - 1);
                    continue;
                }
                sb.append(buffer, 0, actual);
                continue;
            }
            sb.append(buffer, 0, actual);
        }
        reader.close();
        return sb.condense();
    }

    public static void main(String[] args) throws Exception {
        FastStringBuffer sb1 = new FastStringBuffer(256);
        FastStringBuffer sb2 = new FastStringBuffer(256);
        File file = new File(args[0]);
        FileInputStream is = new FileInputStream(file);
        while (true) {
            int b;
            if ((b = ((InputStream)is).read()) < 0) break;
            sb1.append(Integer.toHexString(b) + " ");
            sb2.append((char)b + " ");
            if (sb1.length() <= 80) continue;
            System.out.println(sb1.toString());
            System.out.println(sb2.toString());
            sb1 = new FastStringBuffer(256);
            sb2 = new FastStringBuffer(256);
        }
        System.out.println(sb1.toString());
        System.out.println(sb2.toString());
        ((InputStream)is).close();
    }
}

