/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.SimpleNodeConstructor;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.functions.SystemFunctionCall;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.StringValue;

public class StringFn
extends SystemFunctionCall
implements Callable {
    public int getImplementationMethod() {
        return super.getImplementationMethod() | 8;
    }

    public int getIntrinsicDependencies() {
        if (this.getNumberOfArguments() == 0) {
            return 2;
        }
        return super.getIntrinsicDependencies();
    }

    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        this.useContextItemAsDefault(visitor);
        this.argument[0].setFlattened(true);
        return this.simplifyArguments(visitor);
    }

    public Expression optimize(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        Expression e = super.optimize(visitor, contextItemType);
        if (e != this) {
            return e;
        }
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        if (th.isSubType(this.argument[0].getItemType(th), BuiltInAtomicType.STRING) && this.argument[0].getCardinality() == 16384) {
            return this.argument[0];
        }
        if (this.argument[0] instanceof SimpleNodeConstructor) {
            return ((SimpleNodeConstructor)this.argument[0]).getContentExpression();
        }
        return this;
    }

    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        ItemType operandItemType;
        TypeHierarchy th;
        PathMap.PathMapNodeSet result = this.argument[0].addToPathMap(pathMap, pathMapNodeSet);
        if (!(result == null || result == pathMapNodeSet && !(this.argument[0] instanceof ContextItemExpression) || (th = this.getExecutable().getConfiguration().getTypeHierarchy()).relationship(NodeKindTest.ELEMENT, operandItemType = this.argument[0].getItemType(th)) == 4 && th.relationship(NodeKindTest.DOCUMENT, operandItemType) == 4)) {
            result.setAtomized();
        }
        return null;
    }

    public StringValue evaluateItem(XPathContext c) throws XPathException {
        try {
            Item arg = this.argument[0].evaluateItem(c);
            if (arg == null) {
                return StringValue.EMPTY_STRING;
            }
            if (arg instanceof StringValue && ((StringValue)arg).getItemType() == BuiltInAtomicType.STRING) {
                return (StringValue)arg;
            }
            return StringValue.makeStringValue(arg.getStringValueCS());
        }
        catch (UnsupportedOperationException e) {
            XPathException err = new XPathException(e.getMessage(), "FOTY0014");
            err.setLocator(this);
            err.setXPathContext(c);
            throw err;
        }
    }

    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        if (arguments.length == 0) {
            return new StringValue(context.getContextItem().getStringValueCS());
        }
        return new StringValue(SequenceTool.getStringValue(arguments[0]));
    }
}

