/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.PendingUpdateList;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionLocation;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.functions.SystemFunctionCall;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.sxpath.XPathEvaluator;
import net.sf.saxon.sxpath.XPathExpression;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.SingletonItem;
import net.sf.saxon.value.StringValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Error
extends SystemFunctionCall
implements Callable {
    @Override
    public int computeSpecialProperties() {
        return super.computeSpecialProperties() & 0xFFBFFFFF;
    }

    @Override
    public Expression preEvaluate(ExpressionVisitor visitor) {
        return this;
    }

    @Override
    public boolean isVacuousExpression() {
        return true;
    }

    @Override
    public Item evaluateItem(XPathContext context) throws XPathException {
        int len = this.argument.length;
        switch (len) {
            case 0: {
                return this.error(context, null, null, null);
            }
            case 1: {
                return this.error(context, (QNameValue)this.argument[0].evaluateItem(context), null, null);
            }
            case 2: {
                return this.error(context, (QNameValue)this.argument[0].evaluateItem(context), (StringValue)this.argument[1].evaluateItem(context), null);
            }
            case 3: {
                return this.error(context, (QNameValue)this.argument[0].evaluateItem(context), (StringValue)this.argument[1].evaluateItem(context), this.argument[2].iterate(context));
            }
        }
        return null;
    }

    @Override
    public void evaluatePendingUpdates(XPathContext context, PendingUpdateList pul) throws XPathException {
        this.evaluateItem(context);
    }

    public <EO extends Item> Item error(XPathContext context, QNameValue errorCode, StringValue desc, SequenceIterator<EO> errObject) throws XPathException {
        QNameValue qname = null;
        if (this.argument.length > 0) {
            qname = errorCode;
        }
        if (qname == null) {
            qname = new QNameValue("err", "http://www.w3.org/2005/xqt-errors", this.argument.length == 1 ? "FOTY0004" : "FOER0000", BuiltInAtomicType.QNAME, null);
        }
        String description = this.argument.length > 1 ? (desc == null ? "" : desc.getStringValue()) : "Error signalled by application call on error()";
        XPathException e = new XPathException(description);
        e.setErrorCodeQName(qname.toStructuredQName());
        e.setXPathContext(context);
        e.setLocator(this);
        if (this.argument.length > 2 && errObject != null) {
            Object root;
            GroundedValue errorObject = SequenceExtent.makeSequenceExtent(errObject);
            if (errorObject instanceof SingletonItem && (root = ((SingletonItem)errorObject).asItem()) instanceof NodeInfo && ((NodeInfo)root).getNodeKind() == 9) {
                XPathEvaluator xpath = new XPathEvaluator();
                XPathExpression exp = xpath.createExpression("/error/@module");
                NodeInfo moduleAtt = (NodeInfo)exp.evaluateSingle((NodeInfo)root);
                String module = moduleAtt == null ? null : moduleAtt.getStringValue();
                exp = xpath.createExpression("/error/@line");
                NodeInfo lineAtt = (NodeInfo)exp.evaluateSingle((NodeInfo)root);
                int line = lineAtt == null ? -1 : Integer.parseInt(lineAtt.getStringValue());
                exp = xpath.createExpression("/error/@column");
                NodeInfo columnAtt = (NodeInfo)exp.evaluateSingle((NodeInfo)root);
                int column = columnAtt == null ? -1 : Integer.parseInt(columnAtt.getStringValue());
                ExpressionLocation locator = new ExpressionLocation();
                locator.setSystemId(module);
                locator.setLineNumber(line);
                locator.setColumnNumber(column);
                e.setLocator(locator);
            }
            e.setErrorObject(errorObject);
        }
        throw e;
    }

    @Override
    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        int len = this.argument.length;
        switch (len) {
            case 0: {
                return this.error(context, null, null, null);
            }
            case 1: {
                return this.error(context, (QNameValue)arguments[0].head(), null, null);
            }
            case 2: {
                return this.error(context, (QNameValue)arguments[0].head(), (StringValue)arguments[1].head(), null);
            }
            case 3: {
                return this.error(context, (QNameValue)arguments[0].head(), (StringValue)arguments[1].head(), arguments[2].iterate());
            }
        }
        return null;
    }
}

