/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.Iterator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FirstItemExpression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.PairIterator;
import net.sf.saxon.expr.SingleItemFilter;
import net.sf.saxon.expr.TailIterator;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PromotionOffer;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.GroundedIterator;
import net.sf.saxon.value.MemoClosure;
import net.sf.saxon.value.NumericValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubscriptExpression
extends SingleItemFilter {
    Expression subscript;

    public SubscriptExpression(Expression base, Expression subscript) {
        this.operand = base;
        this.subscript = subscript;
        this.adoptChildExpression(base);
        this.adoptChildExpression(subscript);
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        this.operand = visitor.typeCheck(this.operand, contextItemType);
        this.subscript = visitor.typeCheck(this.subscript, contextItemType);
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        this.operand = visitor.optimize(this.operand, contextItemType);
        this.subscript = visitor.optimize(this.subscript, contextItemType);
        if (Literal.isConstantOne(this.subscript)) {
            return FirstItemExpression.makeFirstItemExpression(this.operand);
        }
        return this;
    }

    @Override
    public Expression promote(PromotionOffer offer, Expression parent) throws XPathException {
        Expression exp = offer.accept(parent, this);
        if (exp != null) {
            return exp;
        }
        if (offer.action != 13) {
            this.operand = this.doPromotion(this.operand, offer);
            this.subscript = this.doPromotion(this.subscript, offer);
        }
        return this;
    }

    @Override
    public Expression copy() {
        return new SubscriptExpression(this.operand.copy(), this.subscript.copy());
    }

    @Override
    public Iterator<Expression> iterateSubExpressions() {
        return new PairIterator<Expression>(this.operand, this.subscript);
    }

    @Override
    public boolean replaceSubExpression(Expression original, Expression replacement) {
        boolean found = false;
        if (this.operand == original) {
            this.operand = replacement;
            found = true;
        } else if (this.subscript == original) {
            this.subscript = replacement;
            found = true;
        }
        return found;
    }

    public Expression getSubscriptExpression() {
        return this.subscript;
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof SubscriptExpression && this.operand.equals(((SubscriptExpression)other).operand) && this.subscript == ((SubscriptExpression)other).subscript;
    }

    @Override
    public int hashCode() {
        return this.operand.hashCode() ^ this.subscript.hashCode();
    }

    @Override
    public int computeCardinality() {
        return 24576;
    }

    @Override
    public Item evaluateItem(XPathContext context) throws XPathException {
        NumericValue index = (NumericValue)this.subscript.evaluateItem(context);
        if (index == null) {
            return null;
        }
        if (index.compareTo(Integer.MAX_VALUE) <= 0 && index.isWholeNumber()) {
            Item item;
            int intindex = (int)index.longValue();
            if (intindex < 1) {
                return null;
            }
            SequenceIterator<? extends Item> iter = this.operand.iterate(context);
            if (intindex == 1) {
                item = iter.next();
            } else if (iter instanceof MemoClosure.ProgressiveIterator) {
                item = ((MemoClosure.ProgressiveIterator)iter).itemAt(intindex - 1);
            } else if ((iter.getProperties() & 1) != 0) {
                GroundedValue value = ((GroundedIterator)iter).materialize();
                item = value.itemAt(intindex - 1);
            } else {
                SequenceIterator<? extends Item> tail = TailIterator.make(iter, intindex);
                item = tail.next();
                tail.close();
            }
            return item;
        }
        return null;
    }

    @Override
    public void explain(ExpressionPresenter destination) {
        destination.startElement("subscript");
        this.operand.explain(destination);
        this.subscript.explain(destination);
        destination.endElement();
    }

    @Override
    public String toString() {
        return ExpressionTool.parenthesize(this.operand) + "[" + this.subscript.toString() + "]";
    }
}

