/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.io.Serializable;
import java.util.HashMap;
import net.sf.saxon.expr.Container;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.functions.IntegratedFunctionCall;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;

public class IntegratedFunctionLibrary
implements FunctionLibrary,
Serializable {
    private HashMap<StructuredQName, ExtensionFunctionDefinition> functions = new HashMap();

    public void registerFunction(ExtensionFunctionDefinition function) {
        this.functions.put(function.getFunctionQName(), function);
    }

    public Expression bind(StructuredQName functionName, int arity, Expression[] staticArgs, StaticContext env, Container container) throws XPathException {
        ExtensionFunctionDefinition defn = this.functions.get(functionName);
        if (defn == null) {
            return null;
        }
        try {
            return IntegratedFunctionLibrary.makeFunctionCall(defn, staticArgs, container);
        }
        catch (Exception err) {
            throw new XPathException("Failed to create call to extension function " + functionName.getDisplayName(), err);
        }
    }

    public static Expression makeFunctionCall(ExtensionFunctionDefinition defn, Expression[] staticArgs, Container container) {
        ExtensionFunctionCall f = defn.makeCallExpression();
        f.setDefinition(defn, container);
        IntegratedFunctionCall fc = new IntegratedFunctionCall(f);
        fc.setFunctionName(defn.getFunctionQName());
        fc.setArguments(staticArgs);
        return fc;
    }

    public boolean isAvailable(StructuredQName functionName, int arity) {
        ExtensionFunctionDefinition defn = this.functions.get(functionName);
        return defn != null && defn.getMaximumNumberOfArguments() >= arity && defn.getMinimumNumberOfArguments() <= arity;
    }

    public FunctionLibrary copy() {
        IntegratedFunctionLibrary lib = new IntegratedFunctionLibrary();
        lib.functions = new HashMap<StructuredQName, ExtensionFunctionDefinition>(this.functions);
        return lib;
    }
}

