/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.CastExpression;
import net.sf.saxon.expr.CastToList;
import net.sf.saxon.expr.CastToUnion;
import net.sf.saxon.expr.Container;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.instruct.SavedNamespaceContext;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnySimpleType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.ListType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.DecimalValue;

public class ConstructorFunctionLibrary
implements FunctionLibrary {
    private Configuration config;

    public ConstructorFunctionLibrary(Configuration config) {
        this.config = config;
    }

    public boolean isAvailable(StructuredQName functionName, int arity) {
        if (arity != 1) {
            return false;
        }
        String uri = functionName.getURI();
        String localName = functionName.getLocalPart();
        int fp = this.config.getNamePool().allocate("", uri, localName);
        SchemaType type = this.config.getSchemaType(fp);
        if (type == null || type.isComplexType()) {
            return false;
        }
        if (type.isAtomicType() && ((AtomicType)type).isAbstract()) {
            return false;
        }
        if (type == AnySimpleType.getInstance()) {
            return false;
        }
        if (type.isAtomicType() && ((AtomicType)type).isAbstract()) {
            return false;
        }
        return type != AnySimpleType.getInstance();
    }

    public Expression bind(StructuredQName functionName, int arity, Expression[] arguments, StaticContext env, Container container) throws XPathException {
        SchemaType st;
        int fp;
        String uri = functionName.getURI();
        String localName = functionName.getLocalPart();
        boolean builtInNamespace = uri.equals("http://www.w3.org/2001/XMLSchema");
        if (builtInNamespace) {
            if (arguments.length != 1) {
                throw new XPathException("A constructor function must have exactly one argument");
            }
            SimpleType type = Type.getBuiltInSimpleType(uri, localName);
            if (type != null) {
                if (type.isAtomicType()) {
                    if (((AtomicType)type).isAbstract()) {
                        XPathException err = new XPathException("Abstract type used in constructor function: {" + uri + '}' + localName);
                        err.setErrorCode("XPST0017");
                        err.setIsStaticError(true);
                        throw err;
                    }
                    CastExpression cast = new CastExpression(arguments[0], (AtomicType)type, true);
                    if (arguments[0] instanceof StringLiteral) {
                        cast.setOperandIsStringLiteral(true);
                    }
                    if (type.isNamespaceSensitive()) {
                        cast.setNamespaceResolver(new SavedNamespaceContext(env.getNamespaceResolver()));
                    }
                    cast.setContainer(container);
                    return cast;
                }
                if (type == ErrorType.getInstance()) {
                    return new CastToUnion(arguments[0], ErrorType.getInstance(), true);
                }
                assert (type.isListType());
                return new CastToList(arguments[0], (ListType)type, true);
            }
            XPathException err = new XPathException("Unknown constructor function: {" + uri + '}' + localName);
            err.setErrorCode("XPST0017");
            err.setIsStaticError(true);
            throw err;
        }
        if (arguments.length == 1 && (fp = this.config.getNamePool().getFingerprint(uri, localName)) != -1 && (st = this.config.getSchemaType(fp)) instanceof SimpleType) {
            if (st instanceof AtomicType) {
                CastExpression cast = new CastExpression(arguments[0], (AtomicType)st, true);
                cast.setContainer(container);
                return cast;
            }
            if (st instanceof ListType && DecimalValue.THREE.equals(env.getXPathLanguageLevel())) {
                return new CastToList(arguments[0], (ListType)st, true);
            }
            if (((SimpleType)st).isUnionType() && DecimalValue.THREE.equals(env.getXPathLanguageLevel())) {
                Expression cast = env.getConfiguration().obtainOptimizer().makeCastToUnion(arguments[0], st, true);
                cast.setContainer(container);
                return cast;
            }
        }
        return null;
    }

    public FunctionLibrary copy() {
        return this;
    }
}

