/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.ArrayIterator;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.GroundedIterator;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SequenceExtent;

public class MemoSequence
implements Sequence {
    SequenceIterator inputIterator;
    private Item[] reservoir = null;
    private int used;
    protected int state;
    private static final int UNREAD = 0;
    private static final int MAYBE_MORE = 1;
    private static final int ALL_READ = 3;
    private static final int BUSY = 4;
    protected static final int EMPTY = 5;

    public MemoSequence(SequenceIterator iterator) {
        this.inputIterator = iterator;
    }

    public Item head() throws XPathException {
        return this.iterate().next();
    }

    public synchronized SequenceIterator iterate() throws XPathException {
        switch (this.state) {
            case 0: {
                this.state = 4;
                if (this.inputIterator instanceof EmptyIterator) {
                    this.state = 5;
                    return this.inputIterator;
                }
                this.reservoir = new Item[50];
                this.used = 0;
                this.state = 1;
                return new ProgressiveIterator();
            }
            case 1: {
                return new ProgressiveIterator();
            }
            case 3: {
                switch (this.used) {
                    case 0: {
                        this.state = 5;
                        return EmptyIterator.emptyIterator();
                    }
                    case 1: {
                        assert (this.reservoir != null);
                        return SingletonIterator.makeIterator(this.reservoir[0]);
                    }
                }
                return new ArrayIterator(this.reservoir, 0, this.used);
            }
            case 4: {
                XPathException de = new XPathException("Attempt to access a variable while it is being evaluated");
                de.setErrorCode("XTDE0640");
                throw de;
            }
            case 5: {
                return EmptyIterator.emptyIterator();
            }
        }
        throw new IllegalStateException("Unknown iterator state");
    }

    private void append(Item item) {
        assert (this.reservoir != null);
        if (this.used >= this.reservoir.length) {
            Item[] r2 = new Item[this.used * 2];
            System.arraycopy(this.reservoir, 0, r2, 0, this.used);
            this.reservoir = r2;
        }
        this.reservoir[this.used++] = item;
    }

    private void condense() {
        if (this.reservoir != null && this.reservoir.length - this.used > 30) {
            Item[] r2 = new Item[this.used];
            System.arraycopy(this.reservoir, 0, r2, 0, this.used);
            this.reservoir = r2;
        }
    }

    public final class ProgressiveIterator
    implements SequenceIterator,
    LastPositionFinder,
    GroundedIterator {
        int position = -1;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Item next() throws XPathException {
            MemoSequence memoSequence = MemoSequence.this;
            synchronized (memoSequence) {
                if (this.position == -2) {
                    return null;
                }
                if (++this.position < MemoSequence.this.used) {
                    assert (MemoSequence.this.reservoir != null);
                    return MemoSequence.this.reservoir[this.position];
                }
                if (MemoSequence.this.state == 3) {
                    this.position = -2;
                    return null;
                }
                assert (MemoSequence.this.inputIterator != null);
                Object i = MemoSequence.this.inputIterator.next();
                if (i == null) {
                    MemoSequence.this.state = 3;
                    MemoSequence.this.condense();
                    this.position = -2;
                    return null;
                }
                this.position = MemoSequence.this.used;
                MemoSequence.this.append(i);
                MemoSequence.this.state = 1;
                return i;
            }
        }

        public Item current() {
            if (this.position < 0) {
                return null;
            }
            assert (MemoSequence.this.reservoir != null);
            return MemoSequence.this.reservoir[this.position];
        }

        public int position() {
            return this.position + 1;
        }

        public void close() {
        }

        public ProgressiveIterator getAnother() {
            return new ProgressiveIterator();
        }

        public int getLength() throws XPathException {
            Item item;
            if (MemoSequence.this.state == 3) {
                return MemoSequence.this.used;
            }
            if (MemoSequence.this.state == 5) {
                return 0;
            }
            int savePos = this.position;
            while ((item = this.next()) != null) {
            }
            this.position = savePos;
            return MemoSequence.this.used;
        }

        public GroundedValue materialize() {
            if (MemoSequence.this.state == 3) {
                assert (MemoSequence.this.reservoir != null);
                return new SequenceExtent(MemoSequence.this.reservoir);
            }
            if (MemoSequence.this.state == 5) {
                return EmptySequence.getInstance();
            }
            throw new IllegalStateException("Progressive iterator is not grounded until all items are read");
        }

        public int getProperties() {
            if (MemoSequence.this.state == 5 || MemoSequence.this.state == 3) {
                return 3;
            }
            return 0;
        }
    }
}

