/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import java.util.Iterator;
import net.sf.saxon.Controller;
import net.sf.saxon.event.OnEmptyHandler;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceOutputter;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.event.TreeReceiver;
import net.sf.saxon.evpull.BracketedElementIterator;
import net.sf.saxon.evpull.EndElementEvent;
import net.sf.saxon.evpull.EventAnnotationStripper;
import net.sf.saxon.evpull.EventIterator;
import net.sf.saxon.evpull.SingletonEventIterator;
import net.sf.saxon.evpull.StartElementEvent;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.PairIterator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.SubExpressionInfo;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.Block;
import net.sf.saxon.expr.instruct.ParentNodeConstructor;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.instruct.ValueOf;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.ComplexType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.Untyped;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.Cardinality;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ElementCreator
extends ParentNodeConstructor {
    protected boolean inheritNamespaces = true;
    protected boolean inheritFromParent = true;
    protected Expression onEmpty = null;

    @Override
    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        if (this.onEmpty != null) {
            this.onEmpty = visitor.simplify(this.onEmpty);
        }
        return super.simplify(visitor);
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        if (this.onEmpty != null) {
            this.onEmpty = visitor.typeCheck(this.onEmpty, contextItemType);
        }
        return super.typeCheck(visitor, contextItemType);
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        if (this.onEmpty != null) {
            this.onEmpty = visitor.optimize(this.onEmpty, contextItemType);
        }
        return super.optimize(visitor, contextItemType);
    }

    @Override
    public ItemType getItemType(TypeHierarchy th) {
        if (this.onEmpty == null) {
            return NodeKindTest.ELEMENT;
        }
        return Type.getCommonSuperType(NodeKindTest.ELEMENT, this.onEmpty.getItemType(th), th);
    }

    @Override
    public int getCardinality() {
        if (this.onEmpty == null) {
            return 16384;
        }
        return Cardinality.union(16384, this.onEmpty.getCardinality());
    }

    @Override
    public Iterator<Expression> iterateSubExpressions() {
        if (this.onEmpty == null) {
            return super.iterateSubExpressions();
        }
        return new PairIterator<Expression>(this.content, this.onEmpty);
    }

    @Override
    public Iterator<SubExpressionInfo> iterateSubExpressionInfo() {
        if (this.onEmpty == null) {
            return super.iterateSubExpressionInfo();
        }
        return new PairIterator<SubExpressionInfo>(new SubExpressionInfo(this.content, true, false, 1), new SubExpressionInfo(this.onEmpty, true, false, 0));
    }

    public boolean isInheritNamespaces() {
        return this.inheritNamespaces;
    }

    public boolean isInheritFromParent() {
        return this.inheritFromParent;
    }

    public void setOnEmpty(Expression onEmpty) {
        this.onEmpty = onEmpty;
    }

    public Expression getOnEmpty() {
        return this.onEmpty;
    }

    @Override
    public int computeSpecialProperties() {
        int p = super.computeSpecialProperties() | 0x800000;
        if (this.getValidationAction() == 4) {
            p |= 0x4000000;
        }
        if (this.onEmpty != null) {
            return p & this.onEmpty.getSpecialProperties();
        }
        return p;
    }

    @Override
    public void suppressValidation(int parentValidationMode) {
        if (this.getValidationAction() == parentValidationMode && this.getSchemaType() == null) {
            this.setValidationAction(3, null);
        }
    }

    @Override
    protected void checkContentSequence(StaticContext env) throws XPathException {
        if (this.content instanceof Block) {
            TypeHierarchy th = env.getConfiguration().getTypeHierarchy();
            Expression[] components = ((Block)this.content).getChildren();
            boolean foundChild = false;
            boolean foundPossibleChild = false;
            int childNodeKinds = 394;
            for (Expression component : components) {
                XPathException de;
                ItemType it = component.getItemType(th);
                if (!(it instanceof NodeTest)) continue;
                boolean maybeEmpty = Cardinality.allowsZero(component.getCardinality());
                int possibleNodeKinds = ((NodeTest)it).getNodeKindMask();
                if ((possibleNodeKinds & 8) != 0) {
                    if (component instanceof ValueOf && ((ValueOf)component).select instanceof StringLiteral) {
                        String value = ((StringLiteral)((ValueOf)component).select).getStringValue();
                        if (value.length() == 0) continue;
                        foundChild = true;
                        continue;
                    }
                    foundPossibleChild = true;
                    continue;
                }
                if ((possibleNodeKinds & ~childNodeKinds) == 0) {
                    if (maybeEmpty) {
                        foundPossibleChild = true;
                        continue;
                    }
                    foundChild = true;
                    continue;
                }
                if (foundChild && possibleNodeKinds == 4 && !maybeEmpty) {
                    de = new XPathException("Cannot create an attribute node after creating a child of the containing element");
                    de.setErrorCode(this.isXSLT() ? "XTDE0410" : "XQTY0024");
                    de.setLocator(component);
                    throw de;
                }
                if (foundChild && possibleNodeKinds == 8192 && !maybeEmpty) {
                    de = new XPathException("Cannot create a namespace node after creating a child of the containing element");
                    de.setErrorCode(this.isXSLT() ? "XTDE0410" : "XQTY0024");
                    de.setLocator(component);
                    throw de;
                }
                if ((foundChild || foundPossibleChild) && possibleNodeKinds == 4) {
                    env.issueWarning("Creating an attribute here will fail if previous instructions create any children", component);
                    continue;
                }
                if (!foundChild && !foundPossibleChild || possibleNodeKinds != 8192) continue;
                env.issueWarning("Creating a namespace node here will fail if previous instructions create any children", component);
            }
        }
    }

    public abstract NodeName getElementName(XPathContext var1, NodeInfo var2) throws XPathException;

    public abstract String getNewBaseURI(XPathContext var1, NodeInfo var2);

    public abstract void outputNamespaceNodes(XPathContext var1, Receiver var2, NodeName var3, NodeInfo var4) throws XPathException;

    public NamespaceBinding[] getActiveNamespaces() throws XPathException {
        return null;
    }

    @Override
    public int getImplementationMethod() {
        return 5;
    }

    @Override
    public EventIterator iterateEvents(XPathContext context) throws XPathException {
        return this.iterateEvents(context, null);
    }

    protected EventIterator iterateEvents(XPathContext context, NodeInfo copiedNode) throws XPathException {
        if (!this.preservingTypes && this.getValidationAction() != 4) {
            return new SingletonEventIterator(this.evaluateItem(context));
        }
        if (this.onEmpty != null) {
            return new SingletonEventIterator(this.evaluateItem(context));
        }
        Controller controller = context.getController();
        assert (controller != null);
        StartElementEvent start = new StartElementEvent(controller.makePipelineConfiguration());
        start.setElementName(this.getElementName(context, copiedNode));
        start.setTypeCode(this.getValidationAction() == 3 ? AnyType.getInstance() : Untyped.getInstance());
        start.setLocalNamespaces(this.getActiveNamespaces());
        start.setLocationId(this.locationId);
        BracketedElementIterator result = new BracketedElementIterator(start, this.content.iterateEvents(context), EndElementEvent.getInstance());
        if (this.getValidationAction() == 4 && controller.getExecutable().isSchemaAware()) {
            return new EventAnnotationStripper(result);
        }
        return result;
    }

    @Override
    public TailCall processLeavingTail(XPathContext context) throws XPathException {
        return this.processLeavingTail(context, null);
    }

    public final TailCall processLeavingTail(XPathContext context, NodeInfo copiedNode) throws XPathException {
        try {
            int properties;
            SequenceReceiver out;
            NodeName elemName = this.getElementName(context, copiedNode);
            ComplexType typeCode = this.getValidationAction() == 3 ? AnyType.getInstance() : Untyped.getInstance();
            SequenceReceiver saved = out = context.getReceiver();
            boolean pop = false;
            SequenceReceiver elemOut = out;
            if (!this.preservingTypes) {
                ParseOptions options = new ParseOptions(this.getValidationOptions());
                options.setTopLevelElement(elemName);
                SequenceReceiver validator = context.getConfiguration().getElementValidator(out, options, this.locationId);
                if (validator != out) {
                    out = new TreeReceiver(validator);
                    context.setReceiver(out);
                    pop = true;
                }
                elemOut = out;
            }
            if (this.onEmpty != null) {
                OnEmptyHandler monitor = new OnEmptyHandler(out, this.onEmpty, context);
                context.setReceiver(monitor);
                pop = true;
                elemOut = monitor;
            }
            if (elemOut.getSystemId() == null) {
                elemOut.setSystemId(this.getNewBaseURI(context, copiedNode));
            }
            int n = properties = this.inheritNamespaces ? 0 : 128;
            if (!this.inheritFromParent) {
                properties |= 0x10000;
            }
            elemOut.startElement(elemName, typeCode, this.locationId, properties);
            this.outputNamespaceNodes(context, elemOut, elemName, copiedNode);
            this.content.process(context);
            elemOut.endElement();
            if (pop) {
                context.setReceiver(saved);
            }
            return null;
        }
        catch (XPathException e) {
            e.maybeSetLocation(this);
            e.maybeSetContext(context);
            throw e;
        }
    }

    @Override
    public Item evaluateItem(XPathContext context) throws XPathException {
        if (this.isLazyConstruction() && this.preservingTypes && this.onEmpty == null) {
            return context.getConfiguration().makeUnconstructedElement(this, context);
        }
        NodeInfo node = this.constructElement(context, null);
        if (this.onEmpty != null && !node.hasChildNodes() && node.iterateAxis((byte)2).next() == null) {
            return this.onEmpty.evaluateItem(context);
        }
        return node;
    }

    private NodeInfo constructElement(XPathContext context, NodeInfo copiedNode) throws XPathException {
        try {
            Controller controller = context.getController();
            assert (controller != null);
            SequenceReceiver saved = context.getReceiver();
            SequenceOutputter seq = controller.allocateSequenceOutputter(1);
            seq.getPipelineConfiguration().setHostLanguage(this.getHostLanguage());
            NodeName elemName = this.getElementName(context, copiedNode);
            ComplexType typeCode = this.getValidationAction() == 3 ? AnyType.getInstance() : Untyped.getInstance();
            SequenceReceiver ini = seq;
            if (!this.preservingTypes) {
                ParseOptions options = new ParseOptions(this.getValidationOptions());
                options.setTopLevelElement(elemName);
                SequenceReceiver validator = controller.getConfiguration().getElementValidator(ini, options, this.locationId);
                if (ini.getSystemId() == null) {
                    ini.setSystemId(this.getNewBaseURI(context, copiedNode));
                }
                if (validator == ini) {
                    context.setReceiver(ini);
                } else {
                    TreeReceiver tr = new TreeReceiver(validator);
                    tr.setPipelineConfiguration(seq.getPipelineConfiguration());
                    context.setReceiver(tr);
                    ini = tr;
                }
            } else {
                context.setReceiver(ini);
                if (ini.getSystemId() == null) {
                    ini.setSystemId(this.getNewBaseURI(context, copiedNode));
                }
            }
            ini.open();
            int properties = this.inheritNamespaces ? 0 : 128;
            ini.startElement(elemName, typeCode, this.locationId, properties);
            this.outputNamespaceNodes(context, ini, elemName, null);
            this.content.process(context);
            ini.endElement();
            ini.close();
            context.setReceiver(saved);
            NodeInfo result = (NodeInfo)seq.popLastItem();
            seq.reset();
            return result;
        }
        catch (XPathException err) {
            if (err instanceof ValidationException) {
                ((ValidationException)err).setSourceLocator(this);
                ((ValidationException)err).setSystemId(this.getSystemId());
            }
            err.maybeSetLocation(this);
            err.maybeSetContext(context);
            throw err;
        }
    }
}

