/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import java.util.Iterator;
import java.util.List;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.GeneralVariable;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PromotionOffer;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WithParam
extends GeneralVariable {
    public static WithParam[] EMPTY_ARRAY = new WithParam[0];
    int parameterId;
    boolean typeChecked = false;

    public void setParameterId(int id) {
        this.parameterId = id;
    }

    public void setTypeChecked(boolean checked) {
        this.typeChecked = checked;
    }

    public int getParameterId() {
        return this.parameterId;
    }

    @Override
    public int getInstructionNameCode() {
        return 207;
    }

    public static void simplify(WithParam[] params, ExpressionVisitor visitor) throws XPathException {
        if (params != null) {
            for (WithParam param : params) {
                Expression select = param.getSelectExpression();
                if (select == null) continue;
                param.setSelectExpression(visitor.simplify(select));
            }
        }
    }

    public static void typeCheck(WithParam[] params, ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        if (params != null) {
            for (WithParam param : params) {
                Expression select = param.getSelectExpression();
                if (select == null) continue;
                param.setSelectExpression(visitor.typeCheck(select, contextItemType));
            }
        }
    }

    public static void optimize(ExpressionVisitor visitor, WithParam[] params, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        if (params != null) {
            for (WithParam param : params) {
                param.optimize(visitor, contextItemType);
            }
        }
    }

    public static void promoteParams(Expression parent, WithParam[] params, PromotionOffer offer) throws XPathException {
        if (params != null) {
            for (WithParam param : params) {
                Expression select = param.getSelectExpression();
                if (select == null) continue;
                param.setSelectExpression(select.promote(offer, parent));
            }
        }
    }

    public static WithParam[] copy(WithParam[] params) {
        if (params == null) {
            return null;
        }
        WithParam[] result = new WithParam[params.length];
        for (int i = 0; i < params.length; ++i) {
            result[i] = new WithParam();
            result[i].parameterId = params[i].parameterId;
            result[i].slotNumber = params[i].slotNumber;
            result[i].typeChecked = params[i].typeChecked;
            result[i].select = params[i].select.copy();
            result[i].requiredType = params[i].requiredType;
            result[i].variableQName = params[i].variableQName;
        }
        return result;
    }

    public static void gatherXPathExpressions(WithParam[] params, List<Expression> list) {
        if (params != null) {
            for (WithParam param : params) {
                Iterator<Expression> it = param.iterateSubExpressions();
                while (it.hasNext()) {
                    list.add(it.next());
                }
            }
        }
    }

    public static void explainParameters(WithParam[] params, ExpressionPresenter out) {
        if (params != null) {
            for (WithParam param : params) {
                out.startElement("withParam");
                out.emitAttribute("name", param.getVariableQName().getDisplayName());
                param.getSelectExpression().explain(out);
                out.endElement();
            }
        }
    }

    public static boolean replaceXPathExpression(WithParam[] params, Expression original, Expression replacement) {
        boolean found = false;
        if (params != null) {
            for (WithParam param : params) {
                boolean f = param.replaceSubExpression(original, replacement);
                found |= f;
            }
        }
        return found;
    }

    @Override
    public Sequence evaluateVariable(XPathContext context) throws XPathException {
        throw new UnsupportedOperationException();
    }

    public boolean isTypeChecked() {
        return this.typeChecked;
    }
}

