/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import net.sf.saxon.om.IdentityComparable;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.StructuredQName;

public class NoNamespaceName
implements NodeName {
    private String localName;
    private int nameCode = -1;

    public NoNamespaceName(String localName) {
        this.localName = localName;
    }

    public NoNamespaceName(String localName, int nameCode) {
        this.localName = localName;
        this.nameCode = nameCode;
    }

    public String getPrefix() {
        return "";
    }

    public String getURI() {
        return "";
    }

    public String getLocalPart() {
        return this.localName;
    }

    public String getDisplayName() {
        return this.localName;
    }

    public StructuredQName getStructuredQName() {
        return new StructuredQName("", "", this.getLocalPart());
    }

    public boolean isInSameNamespace(NodeName other) {
        return other.getURI().length() == 0;
    }

    public boolean isInNamespace(String ns) {
        return ns.length() == 0;
    }

    public NamespaceBinding getNamespaceBinding() {
        return NamespaceBinding.DEFAULT_UNDECLARATION;
    }

    public boolean hasFingerprint() {
        return this.nameCode != -1;
    }

    public int getFingerprint() {
        return this.nameCode;
    }

    public int getNameCode() {
        return this.nameCode;
    }

    public int allocateNameCode(NamePool namePool) {
        if (this.nameCode == -1) {
            this.nameCode = namePool.allocate("", "", this.localName);
            return this.nameCode;
        }
        return this.nameCode;
    }

    public int hashCode() {
        return StructuredQName.computeHashCode("", this.localName);
    }

    public boolean equals(Object obj) {
        return obj instanceof NodeName && ((NodeName)obj).getLocalPart().equals(this.localName) && ((NodeName)obj).isInNamespace("");
    }

    public String toString() {
        return this.localName;
    }

    public boolean isIdentical(IdentityComparable other) {
        if (other instanceof NodeName) {
            return this.equals(other) && this.getPrefix().equals(((NodeName)other).getPrefix());
        }
        return false;
    }
}

