/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.sort.GroupIterator;
import net.sf.saxon.functions.SystemFunctionCall;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.value.DecimalValue;

public class CurrentGroupingKey
extends SystemFunctionCall
implements Callable {
    boolean is30 = false;

    public void checkArguments(ExpressionVisitor visitor) throws XPathException {
        this.is30 = visitor.getStaticContext().getXPathLanguageLevel().equals(DecimalValue.THREE);
        super.checkArguments(visitor);
    }

    public int getIntrinsicDependencies() {
        return 32;
    }

    public SequenceIterator iterate(XPathContext c) throws XPathException {
        GroupIterator gi = c.getCurrentGroupIterator();
        if (gi == null || !gi.hasCurrentGroupingKey()) {
            if (this.is30) {
                XPathException err = new XPathException("There is no current grouping key", "XTDE1071");
                err.setLocator(this);
                throw err;
            }
            return EmptyIterator.emptyIterator();
        }
        return gi.getCurrentGroupingKey().iterate();
    }

    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        return SequenceTool.toLazySequence(this.iterate(context));
    }
}

