/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.xqj;

import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.Properties;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Result;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xquery.XQConnection;
import javax.xml.xquery.XQException;
import javax.xml.xquery.XQItemAccessor;
import javax.xml.xquery.XQItemType;
import javax.xml.xquery.XQResultItem;
import net.sf.saxon.Configuration;
import net.sf.saxon.dom.NodeOverNodeInfo;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.TreeReceiver;
import net.sf.saxon.evpull.BracketedDocumentIterator;
import net.sf.saxon.evpull.Decomposer;
import net.sf.saxon.evpull.EventIterator;
import net.sf.saxon.evpull.EventToStaxBridge;
import net.sf.saxon.evpull.PullEvent;
import net.sf.saxon.evpull.SingletonEventIterator;
import net.sf.saxon.expr.instruct.ResultDocument;
import net.sf.saxon.lib.SerializerFactory;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.wrapper.VirtualNode;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.xqj.Closable;
import net.sf.saxon.xqj.SaxonXQDataFactory;
import net.sf.saxon.xqj.SaxonXQItemAccessor;
import net.sf.saxon.xqj.SaxonXQItemType;
import net.sf.saxon.xqj.SaxonXQSequence;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;

public class SaxonXQItem
extends Closable
implements XQResultItem,
SaxonXQItemAccessor {
    private Item item;
    private Configuration config;
    SaxonXQDataFactory dataFactory;

    public SaxonXQItem(Item item, SaxonXQDataFactory factory) {
        if (item == null) {
            throw new NullPointerException("item");
        }
        this.item = item;
        this.dataFactory = factory;
        this.config = factory.getConfiguration();
        this.setClosableContainer(factory);
    }

    Configuration getConfiguration() {
        return this.config;
    }

    public Item getSaxonItem() {
        return this.item;
    }

    public XQConnection getConnection() throws XQException {
        this.checkNotClosed();
        if (this.dataFactory instanceof XQConnection) {
            return (XQConnection)this.dataFactory;
        }
        return null;
    }

    public String getAtomicValue() throws XQException {
        this.checkNotClosed();
        if (this.item instanceof AtomicValue) {
            return this.item.getStringValue();
        }
        throw new XQException("Failed to getAtomicValue: item is a node, or is closed");
    }

    public boolean getBoolean() throws XQException {
        this.checkNotClosed();
        if (this.item instanceof BooleanValue) {
            return ((BooleanValue)this.item).getBooleanValue();
        }
        throw new XQException("Failed in getBoolean: item is not a boolean, or is closed");
    }

    public byte getByte() throws XQException {
        this.checkNotClosed();
        if (this.item instanceof AtomicValue) {
            AtomicValue prim = (AtomicValue)this.item;
            return (byte)SaxonXQItem.longValue(prim, -128L, 127L);
        }
        throw new XQException("Failed in getByte: item is not an atomic value, or is closed");
    }

    private static long longValue(AtomicValue value, long min, long max) throws XQException {
        if (value instanceof NumericValue) {
            if (value instanceof DoubleValue || value instanceof FloatValue) {
                throw new XQException("Value is a double or float");
            }
            if (!((NumericValue)value).isWholeNumber()) {
                throw new XQException("Value is not a whole number");
            }
            try {
                long val = ((NumericValue)value).longValue();
                if (val >= min && val <= max) {
                    return val;
                }
                throw new XQException("Value is out of range for requested type");
            }
            catch (XPathException err) {
                XQException xqe = new XQException(err.getMessage());
                xqe.initCause((Throwable)err);
                throw xqe;
            }
        }
        throw new XQException("Value is not numeric");
    }

    public double getDouble() throws XQException {
        this.checkNotClosed();
        if (this.item instanceof DoubleValue) {
            return ((DoubleValue)this.item).getDoubleValue();
        }
        throw new XQException("Failed in getDouble: item is not a double, or is closed");
    }

    public float getFloat() throws XQException {
        this.checkNotClosed();
        if (this.item instanceof FloatValue) {
            return ((FloatValue)this.item).getFloatValue();
        }
        throw new XQException("Failed in getFloat: item is not a float, or is closed");
    }

    public int getInt() throws XQException {
        this.checkNotClosed();
        if (this.item instanceof AtomicValue) {
            AtomicValue prim = (AtomicValue)this.item;
            return (int)SaxonXQItem.longValue(prim, Integer.MIN_VALUE, Integer.MAX_VALUE);
        }
        throw new XQException("Failed in getInt: item is not an atomic value, or is closed");
    }

    public XMLStreamReader getItemAsStream() throws XQException {
        this.checkNotClosed();
        PipelineConfiguration pipe = this.config.makePipelineConfiguration();
        pipe.setHostLanguage(51);
        if (this.item instanceof DocumentInfo) {
            Decomposer eventIterator = new Decomposer((NodeInfo)this.item, pipe);
            return new EventToStaxBridge((EventIterator)eventIterator, pipe);
        }
        SingletonEventIterator contentIterator = new SingletonEventIterator((PullEvent)this.item);
        BracketedDocumentIterator eventIterator = new BracketedDocumentIterator((EventIterator)contentIterator);
        eventIterator = new Decomposer((EventIterator)eventIterator, pipe);
        return new EventToStaxBridge((EventIterator)eventIterator, pipe);
    }

    public String getItemAsString(Properties props) throws XQException {
        this.checkNotClosed();
        if (props == null) {
            props = new Properties();
        } else {
            SaxonXQItem.validateSerializationProperties(props, this.config);
        }
        props = SaxonXQSequence.setDefaultProperties(props);
        StringWriter writer = new StringWriter();
        this.writeItem(writer, props);
        return writer.toString();
    }

    protected static void validateSerializationProperties(Properties props, Configuration config) throws XQException {
        Properties validatedProps = new Properties();
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String value = props.getProperty(name);
            String localName = name;
            String uri = "";
            if (name.startsWith("{")) {
                StructuredQName qName = StructuredQName.fromClarkName((String)name);
                localName = qName.getLocalPart();
                uri = qName.getURI();
            }
            try {
                ResultDocument.setSerializationProperty((Properties)validatedProps, (String)uri, (String)localName, (String)value, null, (boolean)false, (Configuration)config);
            }
            catch (XPathException ex) {
                throw new XQException("Invalid serialization property: " + ex.getMessage());
            }
        }
    }

    public XQItemType getItemType() throws XQException {
        this.checkNotClosed();
        if (this.item instanceof AtomicValue) {
            return new SaxonXQItemType((ItemType)((AtomicValue)this.item).getItemType(), this.getConfiguration());
        }
        return new SaxonXQItemType((NodeInfo)this.item);
    }

    public long getLong() throws XQException {
        this.checkNotClosed();
        if (this.item instanceof AtomicValue) {
            AtomicValue prim = (AtomicValue)this.item;
            return (byte)SaxonXQItem.longValue(prim, Long.MIN_VALUE, Long.MAX_VALUE);
        }
        throw new XQException("Failed in getLong: item is not an atomic value, or is closed");
    }

    public Node getNode() throws XQException {
        Object n;
        this.checkNotClosed();
        if (!(this.item instanceof NodeInfo)) {
            throw new XQException("Failed in getNode: item is an atomic value, or is closed");
        }
        if (this.item instanceof VirtualNode && (n = ((VirtualNode)this.item).getRealNode()) instanceof Node) {
            return (Node)n;
        }
        return NodeOverNodeInfo.wrap((NodeInfo)((NodeInfo)this.item));
    }

    public URI getNodeUri() throws XQException {
        this.checkNotClosed();
        if (this.item instanceof NodeInfo) {
            try {
                String systemId = ((NodeInfo)this.item).getSystemId();
                if (systemId == null) {
                    return new URI("");
                }
                return new URI(systemId);
            }
            catch (URISyntaxException e) {
                throw new XQException("System ID of node is not a valid URI");
            }
        }
        throw new XQException("Item is not a node");
    }

    public Object getObject() throws XQException {
        this.checkNotClosed();
        return this.dataFactory.getObjectConverter().toObject((XQItemAccessor)this);
    }

    public short getShort() throws XQException {
        this.checkNotClosed();
        if (this.item instanceof AtomicValue) {
            AtomicValue prim = (AtomicValue)this.item;
            return (short)SaxonXQItem.longValue(prim, -32768L, 32767L);
        }
        throw new XQException("Failed in getShort: item is not an atomic value, or is closed");
    }

    public boolean instanceOf(XQItemType type) throws XQException {
        this.checkNotClosed();
        this.checkNotNull(type);
        return ((SaxonXQItemType)type).getSaxonItemType().matchesItem(this.item, false, this.config);
    }

    public void writeItem(OutputStream os, Properties props) throws XQException {
        this.checkNotClosed();
        this.checkNotNull(os);
        this.writeItemToResult(new StreamResult(os), props);
    }

    public void writeItem(Writer ow, Properties props) throws XQException {
        this.checkNotClosed();
        this.checkNotNull(ow);
        this.writeItemToResult(new StreamResult(ow), props);
    }

    public void writeItemToResult(Result result) throws XQException {
        this.checkNotClosed();
        this.checkNotNull(result);
        this.writeItemToResult(result, new Properties());
    }

    private void writeItemToResult(Result result, Properties props) throws XQException {
        this.checkNotClosed();
        this.checkNotNull(result);
        if (props == null) {
            props = new Properties();
        }
        props = SaxonXQSequence.setDefaultProperties(props);
        try {
            SerializerFactory sf = this.config.getSerializerFactory();
            PipelineConfiguration pipe = this.config.makePipelineConfiguration();
            Receiver out = sf.getReceiver(result, pipe, props);
            TreeReceiver tr = new TreeReceiver(out);
            tr.open();
            tr.append(this.item, 0, 2);
            tr.close();
        }
        catch (XPathException e) {
            XQException xqe = new XQException(e.getMessage());
            xqe.initCause((Throwable)e);
            throw xqe;
        }
    }

    public void writeItemToSAX(ContentHandler saxHandler) throws XQException {
        this.checkNotClosed();
        this.checkNotNull(saxHandler);
        this.writeItemToResult(new SAXResult(saxHandler));
    }

    private void checkNotNull(Object arg) throws XQException {
        if (arg == null) {
            throw new XQException("Argument is null");
        }
    }
}

