/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import net.sf.saxon.om.FingerprintedNode;
import net.sf.saxon.om.IdentityComparable;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.StructuredQName;

public class NameOfNode
implements NodeName {
    private NodeInfo node;

    public NameOfNode(NodeInfo node) {
        this.node = node;
    }

    public String getPrefix() {
        return this.node.getPrefix();
    }

    public String getURI() {
        return this.node.getURI();
    }

    public String getLocalPart() {
        return this.node.getLocalPart();
    }

    public String getDisplayName() {
        return this.node.getDisplayName();
    }

    public StructuredQName getStructuredQName() {
        return new StructuredQName(this.getPrefix(), this.getURI(), this.getLocalPart());
    }

    public boolean isInSameNamespace(NodeName other) {
        return this.node.getURI().equals(other.getURI());
    }

    public boolean isInNamespace(String ns) {
        return this.node.getURI().equals(ns);
    }

    public NamespaceBinding getNamespaceBinding() {
        return NamespaceBinding.makeNamespaceBinding(this.getPrefix(), this.getURI());
    }

    public boolean hasFingerprint() {
        return this.node instanceof FingerprintedNode;
    }

    public int getFingerprint() {
        if (this.hasFingerprint()) {
            return this.node.getFingerprint();
        }
        return -1;
    }

    public int getNameCode() {
        if (this.hasFingerprint()) {
            return this.node.getNameCode();
        }
        return -1;
    }

    public int allocateNameCode(NamePool namePool) {
        return this.node.getNameCode();
    }

    public int hashCode() {
        return StructuredQName.computeHashCode(this.getURI(), this.getLocalPart());
    }

    public boolean equals(Object obj) {
        if (obj instanceof NodeName) {
            NodeName n = (NodeName)obj;
            if (this.node instanceof FingerprintedNode && n.hasFingerprint()) {
                return this.node.getFingerprint() == n.getFingerprint();
            }
            return n.getLocalPart().equals(this.node.getLocalPart()) && n.isInNamespace(this.node.getURI());
        }
        return false;
    }

    public boolean isIdentical(IdentityComparable other) {
        if (other instanceof NodeName) {
            return this.equals(other) && this.getPrefix().equals(((NodeName)other).getPrefix());
        }
        return false;
    }
}

