/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.value.EmptySequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingletonItem<T extends Item>
implements GroundedValue {
    protected T item = null;

    public SingletonItem(T item) {
        this.item = item;
    }

    @Override
    public CharSequence getStringValueCS() throws XPathException {
        return this.item.getStringValueCS();
    }

    @Override
    public Item head() throws XPathException {
        return this.item;
    }

    public T asItem() {
        return this.item;
    }

    public void process(XPathContext context) throws XPathException {
        if (this.item != null) {
            context.getReceiver().append((Item)this.item, 0, 2);
        }
    }

    public int getCardinality() {
        if (this.item == null) {
            return 8192;
        }
        return 16384;
    }

    @Override
    public int getLength() {
        return this.item == null ? 0 : 1;
    }

    public T itemAt(int n) {
        if (n == 0 && this.item != null) {
            return this.item;
        }
        return null;
    }

    @Override
    public GroundedValue subsequence(int start, int length) {
        if (this.item != null && start <= 0 && start + length > 0) {
            return this;
        }
        return EmptySequence.getInstance();
    }

    public SequenceIterator<T> iterate() {
        return SingletonIterator.makeIterator(this.item);
    }

    @Override
    public boolean effectiveBooleanValue() {
        return this.item != null;
    }

    @Override
    public String getStringValue() {
        return this.item == null ? "" : this.item.getStringValue();
    }

    public String toString() {
        return this.item.toString();
    }

    @Override
    public GroundedValue reduce() {
        return this;
    }
}

