/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.BigRangeIterator;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.expr.ReverseRangeIterator;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.GroundedIterator;
import net.sf.saxon.tree.iter.LookaheadIterator;
import net.sf.saxon.tree.iter.ReversibleIterator;
import net.sf.saxon.value.BigIntegerValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerRange;
import net.sf.saxon.value.IntegerValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RangeIterator
implements SequenceIterator<IntegerValue>,
ReversibleIterator<IntegerValue>,
LastPositionFinder<IntegerValue>,
LookaheadIterator<IntegerValue>,
GroundedIterator<IntegerValue> {
    long start;
    long currentValue;
    long limit;

    public static SequenceIterator makeRangeIterator(IntegerValue start, IntegerValue end) throws XPathException {
        if (start == null || end == null) {
            return EmptyIterator.getInstance();
        }
        if (start.compareTo(end) > 0) {
            return EmptyIterator.getInstance();
        }
        if (start instanceof BigIntegerValue || end instanceof BigIntegerValue) {
            return new BigRangeIterator(start.asBigInteger(), end.asBigInteger());
        }
        return new RangeIterator(start.longValue(), end.longValue());
    }

    public RangeIterator(long start, long end) throws XPathException {
        if (end - start > Integer.MAX_VALUE) {
            throw new XPathException("Saxon limit on sequence length exceeded (2^32-1)");
        }
        this.start = start;
        this.currentValue = start - 1L;
        this.limit = end;
    }

    @Override
    public boolean hasNext() {
        return this.currentValue < this.limit;
    }

    @Override
    public IntegerValue next() {
        if (++this.currentValue > this.limit) {
            return null;
        }
        return Int64Value.makeIntegerValue(this.currentValue);
    }

    @Override
    public IntegerValue current() {
        if (this.currentValue > this.limit) {
            return null;
        }
        return Int64Value.makeIntegerValue(this.currentValue);
    }

    @Override
    public int position() {
        if (this.currentValue > this.limit) {
            return -1;
        }
        return (int)(this.currentValue - this.start + 1L);
    }

    @Override
    public void close() {
    }

    @Override
    public int getLength() {
        return (int)(this.limit - this.start + 1L);
    }

    @Override
    public SequenceIterator<IntegerValue> getAnother() throws XPathException {
        return new RangeIterator(this.start, this.limit);
    }

    @Override
    public int getProperties() {
        return 7;
    }

    @Override
    public SequenceIterator<IntegerValue> getReverseIterator() {
        try {
            return new ReverseRangeIterator(this.limit, this.start);
        }
        catch (XPathException err) {
            throw new AssertionError((Object)err);
        }
    }

    @Override
    public GroundedValue materialize() {
        return new IntegerRange(this.start, this.limit);
    }
}

