/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.Arrays;
import java.util.Iterator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.expr.parser.PromotionOffer;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.NoDynamicContextException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.value.SequenceExtent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FunctionCall
extends Expression {
    private StructuredQName name;
    protected Expression[] argument;

    public final void setFunctionName(StructuredQName name) {
        this.name = name;
    }

    public StructuredQName getFunctionName() {
        return this.name;
    }

    public final int getNumberOfArguments() {
        return this.argument.length;
    }

    public void setArguments(Expression[] args) {
        this.argument = args;
        for (Expression arg : args) {
            this.adoptChildExpression(arg);
        }
    }

    public Expression[] getArguments() {
        return this.argument;
    }

    @Override
    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        return this.simplifyArguments(visitor);
    }

    protected final Expression simplifyArguments(ExpressionVisitor visitor) throws XPathException {
        for (int i = 0; i < this.argument.length; ++i) {
            Expression exp = visitor.simplify(this.argument[i]);
            if (exp == this.argument[i]) continue;
            this.adoptChildExpression(exp);
            this.argument[i] = exp;
        }
        return this;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        boolean fixed = true;
        for (int i = 0; i < this.argument.length; ++i) {
            Expression exp = visitor.typeCheck(this.argument[i], contextItemType);
            if (exp != this.argument[i]) {
                this.adoptChildExpression(exp);
                this.argument[i] = exp;
            }
            if (this.argument[i] instanceof Literal) continue;
            fixed = false;
        }
        this.checkArguments(visitor);
        if (fixed) {
            try {
                return this.preEvaluate(visitor);
            }
            catch (NoDynamicContextException err) {
                return this;
            }
        }
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        boolean fixed = true;
        for (int i = 0; i < this.argument.length; ++i) {
            Expression exp = visitor.optimize(this.argument[i], contextItemType);
            if (exp != this.argument[i]) {
                this.adoptChildExpression(exp);
                this.argument[i] = exp;
            }
            if (!fixed || this.argument[i] instanceof Literal) continue;
            fixed = false;
        }
        this.checkArguments(visitor);
        if (fixed) {
            return this.preEvaluate(visitor);
        }
        return this;
    }

    public Expression preEvaluate(ExpressionVisitor visitor) throws XPathException {
        if (this.getIntrinsicDependencies() != 0) {
            return this;
        }
        try {
            Literal lit = Literal.makeLiteral(SequenceExtent.makeSequenceExtent(this.iterate(visitor.getStaticContext().makeEarlyEvaluationContext())));
            ExpressionTool.copyLocationInfo(this, lit);
            return lit;
        }
        catch (NoDynamicContextException e) {
            return this;
        }
        catch (UnsupportedOperationException e) {
            if (e.getCause() instanceof NoDynamicContextException) {
                return this;
            }
            throw e;
        }
    }

    @Override
    public Expression promote(PromotionOffer offer, Expression parent) throws XPathException {
        Expression exp = offer.accept(parent, this);
        if (exp != null) {
            return exp;
        }
        if (offer.action != 13) {
            for (int i = 0; i < this.argument.length; ++i) {
                this.argument[i] = this.doPromotion(this.argument[i], offer);
            }
        }
        return this;
    }

    protected abstract void checkArguments(ExpressionVisitor var1) throws XPathException;

    protected int checkArgumentCount(int min, int max) throws XPathException {
        int numArgs = this.argument.length;
        String msg = null;
        if (min == max && numArgs != min) {
            msg = "Function " + this.getDisplayName() + " must have " + min + FunctionCall.pluralArguments(min);
        } else if (numArgs < min) {
            msg = "Function " + this.getDisplayName() + " must have at least " + min + FunctionCall.pluralArguments(min);
        } else if (numArgs > max) {
            msg = "Function " + this.getDisplayName() + " must have no more than " + max + FunctionCall.pluralArguments(max);
        }
        if (msg != null) {
            XPathException err = new XPathException(msg, "XPST0017");
            err.setIsStaticError(true);
            err.setLocator(this);
            throw err;
        }
        return numArgs;
    }

    private static String pluralArguments(int num) {
        if (num == 1) {
            return " argument";
        }
        return " arguments";
    }

    @Override
    public Iterator<Expression> iterateSubExpressions() {
        return Arrays.asList(this.argument).iterator();
    }

    @Override
    public boolean replaceSubExpression(Expression original, Expression replacement) {
        boolean found = false;
        for (int i = 0; i < this.argument.length; ++i) {
            if (this.argument[i] != original) continue;
            this.argument[i] = replacement;
            found = true;
        }
        return found;
    }

    public PathMap.PathMapNodeSet addExternalFunctionCallToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodes) {
        PathMap.PathMapNodeSet result = new PathMap.PathMapNodeSet();
        Iterator<Expression> iter = this.iterateSubExpressions();
        while (iter.hasNext()) {
            Expression child = iter.next();
            result.addNodeSet(child.addToPathMap(pathMap, pathMapNodes));
        }
        result.setHasUnknownDependencies();
        return result;
    }

    @Override
    public final String getExpressionName() {
        return this.getDisplayName();
    }

    public final String getDisplayName() {
        StructuredQName fName = this.getFunctionName();
        return fName == null ? "(anonymous)" : fName.getDisplayName();
    }

    @Override
    public String toString() {
        FastStringBuffer buff = new FastStringBuffer(64);
        StructuredQName fName = this.getFunctionName();
        String f = fName == null ? "$anonymousFunction" : (fName.isInNamespace("http://www.w3.org/2005/xpath-functions") ? fName.getLocalPart() : fName.getEQName());
        buff.append(f);
        Iterator<Expression> iter = this.iterateSubExpressions();
        boolean first = true;
        while (iter.hasNext()) {
            buff.append(first ? "(" : ", ");
            buff.append(((Object)iter.next()).toString());
            first = false;
        }
        buff.append(first ? "()" : ")");
        return buff.toString();
    }

    @Override
    public void explain(ExpressionPresenter out) {
        out.startElement("functionCall");
        out.emitAttribute("name", this.getDisplayName());
        for (Expression anArgument : this.argument) {
            anArgument.explain(out);
        }
        out.endElement();
    }

    public boolean equals(Object o) {
        if (!(o instanceof FunctionCall)) {
            return false;
        }
        FunctionCall f = (FunctionCall)o;
        if (!this.getFunctionName().equals(f.getFunctionName())) {
            return false;
        }
        if (this.getNumberOfArguments() != f.getNumberOfArguments()) {
            return false;
        }
        for (int i = 0; i < this.getNumberOfArguments(); ++i) {
            if (this.argument[i].equals(f.argument[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int h = this.getFunctionName().hashCode();
        for (int i = 0; i < this.getNumberOfArguments(); ++i) {
            h ^= this.argument[i].hashCode();
        }
        return h;
    }
}

