/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.expr.RangeIterator;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.LookaheadIterator;
import net.sf.saxon.tree.iter.ReversibleIterator;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReverseRangeIterator
implements SequenceIterator<IntegerValue>,
ReversibleIterator<IntegerValue>,
LastPositionFinder<IntegerValue>,
LookaheadIterator<IntegerValue> {
    long start;
    long currentValue;
    long limit;

    public ReverseRangeIterator(long start, long end) throws XPathException {
        if (start - end > Integer.MAX_VALUE) {
            throw new XPathException("Saxon limit on sequence length exceeded (2^32-1)");
        }
        this.start = start;
        this.currentValue = start + 1L;
        this.limit = end;
    }

    @Override
    public boolean hasNext() {
        return this.currentValue > this.limit;
    }

    @Override
    public IntegerValue next() {
        if (--this.currentValue < this.limit) {
            return null;
        }
        return Int64Value.makeIntegerValue(this.currentValue);
    }

    @Override
    public IntegerValue current() {
        if (this.currentValue < this.limit) {
            return null;
        }
        return Int64Value.makeIntegerValue(this.currentValue);
    }

    @Override
    public int position() {
        if (this.currentValue < this.limit) {
            return -1;
        }
        return (int)(this.start - this.currentValue + 1L);
    }

    @Override
    public void close() {
    }

    @Override
    public int getLength() {
        return (int)(this.start - this.limit + 1L);
    }

    @Override
    public SequenceIterator<IntegerValue> getAnother() throws XPathException {
        return new ReverseRangeIterator(this.start, this.limit);
    }

    @Override
    public int getProperties() {
        return 6;
    }

    @Override
    public SequenceIterator<IntegerValue> getReverseIterator() {
        try {
            return new RangeIterator(this.limit, this.start);
        }
        catch (XPathException err) {
            throw new AssertionError((Object)err);
        }
    }
}

