/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.BooleanValue;

public final class IsLastExpression
extends Expression {
    private boolean condition;

    public IsLastExpression(boolean condition) {
        this.condition = condition;
    }

    public boolean getCondition() {
        return this.condition;
    }

    public Expression typeCheck(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) {
        return this;
    }

    public Expression optimize(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) {
        return this;
    }

    public int computeSpecialProperties() {
        int p = super.computeSpecialProperties();
        return p | 0x400000;
    }

    public BooleanValue evaluateItem(XPathContext c) throws XPathException {
        return BooleanValue.get(this.condition == c.isAtLast());
    }

    public ItemType getItemType(TypeHierarchy th) {
        return BuiltInAtomicType.BOOLEAN;
    }

    public int computeCardinality() {
        return 16384;
    }

    public int getIntrinsicDependencies() {
        return 12;
    }

    public Expression copy() {
        return new IsLastExpression(this.condition);
    }

    public void explain(ExpressionPresenter destination) {
        destination.startElement("isLast");
        destination.emitAttribute("condition", this.condition ? "true" : "false");
        destination.endElement();
    }

    public String toString() {
        if (this.condition) {
            return "position() eq last()";
        }
        return "position() ne last()";
    }
}

